/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.security.basic;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.ext.Provider;

@Provider
@Priority(value=3000)
public class ClientBasicAuthFilter
implements ClientRequestFilter {
    private static final String HEADER_FORMAT = "Basic %s";
    private final String headerValue;

    public ClientBasicAuthFilter(String username, String password) {
        this(username, password, StandardCharsets.UTF_8);
    }

    public ClientBasicAuthFilter(String username, String password, Charset charset) {
        this.headerValue = String.format(HEADER_FORMAT, Base64.getEncoder().encodeToString(String.format("%s:%s", username, password).getBytes(charset)));
    }

    public void filter(ClientRequestContext request) throws IOException {
        request.getHeaders().putSingle((Object)"Authorization", (Object)this.headerValue);
    }
}

