/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.security.basic;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.ext.Provider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

@Provider
@Priority(value=3000)
public class ClientBasicAuthFilter
implements ClientRequestFilter {
    private static final String HEADER_FORMAT = "Basic %s";
    private static final String ENCODED_VALUE_FORMAT = "%s:%s";
    private final String headerValue;

    public ClientBasicAuthFilter(String username, String password) {
        this(username, password, StandardCharsets.UTF_8);
    }

    public ClientBasicAuthFilter(String username, String password, Charset charset) {
        this.headerValue = String.format(HEADER_FORMAT, Base64.getEncoder().encodeToString(String.format(ENCODED_VALUE_FORMAT, username, password).getBytes(charset)));
    }

    public void filter(ClientRequestContext request) {
        request.getHeaders().putSingle((Object)"Authorization", (Object)this.headerValue);
    }
}

