/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.security.token;

import jakarta.annotation.Priority;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.ext.Provider;
import java.util.Optional;
import lombok.Generated;
import org.jaxxy.security.token.TokenAuthenticator;

@Provider
@Priority(value=1000)
public class ContainerTokenAuthFilter
implements ContainerRequestFilter {
    private static final String BEARER_SCHEME = "Bearer";
    private static final String SPACE = " ";
    private static final String HEADER_PREFIX = "Bearer ";
    private static final int HEADER_PREFIX_LENGTH = "Bearer ".length();
    private final TokenAuthenticator authenticator;

    public void filter(ContainerRequestContext request) {
        SecurityContext securityContext = Optional.ofNullable(request.getHeaderString("Authorization")).filter((? super T header) -> header.startsWith(HEADER_PREFIX)).map(header -> header.substring(HEADER_PREFIX_LENGTH)).map(this.authenticator::authenticate).orElseThrow(() -> new NotAuthorizedException((Object)BEARER_SCHEME, new Object[0]));
        request.setSecurityContext(securityContext);
    }

    @Generated
    public static ContainerTokenAuthFilterBuilder builder() {
        return new ContainerTokenAuthFilterBuilder();
    }

    @Generated
    public ContainerTokenAuthFilter(TokenAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Generated
    public static class ContainerTokenAuthFilterBuilder {
        @Generated
        private TokenAuthenticator authenticator;

        @Generated
        ContainerTokenAuthFilterBuilder() {
        }

        @Generated
        public ContainerTokenAuthFilterBuilder authenticator(TokenAuthenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        @Generated
        public ContainerTokenAuthFilter build() {
            return new ContainerTokenAuthFilter(this.authenticator);
        }

        @Generated
        public String toString() {
            return "ContainerTokenAuthFilter.ContainerTokenAuthFilterBuilder(authenticator=" + this.authenticator + ")";
        }
    }
}

