/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.FileUtil;
import org.jbake.app.Parser;

public class Crawler {
    private File source;
    private CompositeConfiguration config;
    private List<Map<String, Object>> pages = new ArrayList<Map<String, Object>>();
    private List<Map<String, Object>> posts = new ArrayList<Map<String, Object>>();
    private Map<String, List<Map<String, Object>>> postsByTags = new HashMap<String, List<Map<String, Object>>>();

    public Crawler(File source, CompositeConfiguration config) {
        this.source = source;
        this.config = config;
    }

    public void crawl(File path) {
        Parser parser = new Parser();
        Object[] contents = path.listFiles(FileUtil.getFileFilter());
        if (contents != null) {
            Arrays.sort(contents);
            for (int i = 0; i < contents.length; ++i) {
                if (((File)contents[i]).isFile()) {
                    System.out.print("Processing [" + ((File)contents[i]).getPath() + "]... ");
                    Map<String, Object> fileContents = parser.processFile((File)contents[i]);
                    if (fileContents != null) {
                        fileContents.put("file", ((File)contents[i]).getPath());
                        String uri = ((File)contents[i]).getPath().replace(this.source.getPath() + File.separator + this.config.getString("content.folder"), "");
                        uri = uri.substring(0, uri.lastIndexOf("."));
                        fileContents.put("uri", uri + this.config.getString("output.extension"));
                        if (fileContents.get("type").equals("page")) {
                            this.pages.add(fileContents);
                        } else {
                            this.posts.add(fileContents);
                            if (fileContents.get("tags") != null) {
                                String[] tags;
                                for (String tag : tags = (String[])fileContents.get("tags")) {
                                    if (this.postsByTags.containsKey(tag)) {
                                        this.postsByTags.get(tag).add(fileContents);
                                        continue;
                                    }
                                    ArrayList<Map<String, Object>> posts = new ArrayList<Map<String, Object>>();
                                    posts.add(fileContents);
                                    this.postsByTags.put(tag, posts);
                                }
                            }
                        }
                        System.out.println("done!");
                    }
                }
                if (!((File)contents[i]).isDirectory()) continue;
                this.crawl((File)contents[i]);
            }
        }
    }

    public List<Map<String, Object>> getPages() {
        return this.pages;
    }

    public void setPages(List<Map<String, Object>> pages) {
        this.pages = pages;
    }

    public List<Map<String, Object>> getPosts() {
        return this.posts;
    }

    public void setPosts(List<Map<String, Object>> posts) {
        this.posts = posts;
    }

    public Map<String, List<Map<String, Object>>> getPostsByTags() {
        return this.postsByTags;
    }

    public void setPostsByTags(Map<String, List<Map<String, Object>>> postsByTags) {
        this.postsByTags = postsByTags;
    }
}

