/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.petebevin.markdown.MarkdownProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class Parser {
    private Map<String, Object> content = new HashMap<String, Object>();

    public Map<String, Object> processFile(File file) {
        this.content = new HashMap<String, Object>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            List fileContents = IOUtils.readLines((Reader)reader);
            boolean validFile = false;
            validFile = this.validate(fileContents);
            if (!validFile) {
                return null;
            }
            this.processHeader(fileContents);
            this.processBody(fileContents, file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return this.content;
    }

    private boolean validate(List<String> contents) {
        boolean headerFound = false;
        boolean statusFound = false;
        boolean typeFound = false;
        for (String line : contents) {
            if (line.equals("~~~~~~")) {
                headerFound = true;
            }
            if (line.startsWith("type=")) {
                typeFound = true;
            }
            if (!line.startsWith("status=")) continue;
            statusFound = true;
        }
        if (!(headerFound && statusFound && typeFound)) {
            System.out.println("");
            if (!headerFound) {
                System.out.println("Missing required header");
            }
            if (!statusFound) {
                System.out.println("Missing required header tag: status");
            }
            if (!typeFound) {
                System.out.println("Missing required header tag: type");
            }
            return false;
        }
        return true;
    }

    private void processHeader(List<String> contents) {
        for (String line : contents) {
            if (line.equals("~~~~~~")) break;
            String[] parts = line.split("=");
            if (parts.length != 2) continue;
            if (parts[0].equalsIgnoreCase("date")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = df.parse(parts[1]);
                    this.content.put(parts[0], date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (parts[0].equalsIgnoreCase("tags")) {
                this.content.put(parts[0], parts[1].split(","));
                continue;
            }
            this.content.put(parts[0], parts[1]);
        }
    }

    private void processBody(List<String> contents, File file) {
        StringBuffer body = new StringBuffer();
        boolean inBody = false;
        for (String line : contents) {
            if (inBody) {
                body.append(line + "\n");
            }
            if (!line.equals("~~~~~~")) continue;
            inBody = true;
        }
        if (file.getPath().endsWith(".md")) {
            MarkdownProcessor markdown = new MarkdownProcessor();
            this.content.put("body", markdown.markdown(body.toString()));
        } else {
            this.content.put("body", body.toString());
        }
    }
}

