/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.jbake.app.Oven;
import org.jbake.launcher.LaunchOptions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class Main {
    public static final String VERSION = "v2.1";
    private final String USAGE_PREFIX = "Usage: jbake";

    public static void main(String[] args) {
        Main m = new Main();
        m.run(m.parseArguments(args));
    }

    private void run(LaunchOptions options) {
        try {
            Oven oven = new Oven(options.getSource(), options.getDestination());
            oven.setupPaths();
            oven.bake();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private LaunchOptions parseArguments(String[] args) {
        LaunchOptions res = new LaunchOptions();
        CmdLineParser parser = new CmdLineParser((Object)res);
        try {
            parser.parseArgument(args);
            if (res.isHelpNeeded()) {
                this.printUsage(parser);
            }
        }
        catch (CmdLineException e) {
            this.printUsage(parser);
        }
        return res;
    }

    private void printUsage(CmdLineParser parser) {
        StringWriter sw = new StringWriter();
        sw.append("Usage: jbake");
        parser.printSingleLineUsage((Writer)sw, null);
        System.out.println(sw.toString());
        parser.setUsageWidth(100);
        parser.printUsage((OutputStream)System.out);
        System.exit(0);
    }
}

