/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.petebevin.markdown.MarkdownProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.IOUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.DocumentHeader;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;

public class Parser {
    private CompositeConfiguration config;
    private Map<String, Object> content = new HashMap<String, Object>();
    private Asciidoctor asciidoctor;

    public Parser() {
        this.asciidoctor = Asciidoctor.Factory.create();
    }

    public Parser(CompositeConfiguration config) {
        this.config = config;
        this.asciidoctor = Asciidoctor.Factory.create();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> processFile(File file) {
        this.content = new HashMap<String, Object>();
        BufferedReader reader = null;
        List fileContents = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            fileContents = IOUtils.readLines((Reader)reader);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        boolean hasHeader = this.hasHeader(fileContents);
        if (file.getPath().endsWith(".md") || file.getPath().endsWith(".html")) {
            if (hasHeader) {
                this.processHeader(fileContents);
                this.processBody(fileContents, file);
                return this.content;
            }
            System.err.println("Error parsing meta data from header!");
            return null;
        }
        if (!file.getPath().endsWith(".asciidoc") && !file.getPath().endsWith(".ad")) {
            if (!file.getPath().endsWith(".adoc")) return null;
        }
        if (hasHeader) {
            this.processHeader(fileContents);
            this.processBody(fileContents, file);
            return this.content;
        }
        if (this.validateAsciiDoc(file)) {
            this.processAsciiDocHeader(file);
            this.processAsciiDoc(fileContents);
            return this.content;
        }
        System.err.println("Error parsing meta data from header!");
        return null;
    }

    private boolean hasHeader(List<String> contents) {
        boolean headerValid = false;
        boolean headerSeparatorFound = false;
        boolean statusFound = false;
        boolean typeFound = false;
        ArrayList<String> header = new ArrayList<String>();
        for (String line : contents) {
            header.add(line);
            if (line.contains("=")) {
                if (line.startsWith("type=")) {
                    typeFound = true;
                }
                if (line.startsWith("status=")) {
                    statusFound = true;
                }
            }
            if (!line.equals("~~~~~~")) continue;
            headerSeparatorFound = true;
            header.remove(line);
            break;
        }
        if (headerSeparatorFound) {
            headerValid = true;
            for (String headerLine : header) {
                if (headerLine.contains("=")) continue;
                headerValid = false;
                break;
            }
        }
        return headerValid && statusFound && typeFound;
    }

    private void processHeader(List<String> contents) {
        for (String line : contents) {
            if (line.equals("~~~~~~")) break;
            String[] parts = line.split("=");
            if (parts.length != 2) continue;
            if (parts[0].equalsIgnoreCase("date")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = df.parse(parts[1]);
                    this.content.put(parts[0], date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (parts[0].equalsIgnoreCase("tags")) {
                this.content.put(parts[0], parts[1].split(","));
                continue;
            }
            this.content.put(parts[0], parts[1]);
        }
    }

    private boolean validateAsciiDoc(File file) {
        DocumentHeader header = this.asciidoctor.readDocumentHeader(file);
        boolean statusFound = false;
        boolean typeFound = false;
        for (String key : header.getAttributes().keySet()) {
            if (key.equals("jbake-status")) {
                statusFound = true;
            }
            if (!key.equals("jbake-type")) continue;
            typeFound = true;
        }
        return statusFound && typeFound;
    }

    private void processAsciiDocHeader(File file) {
        DocumentHeader header = this.asciidoctor.readDocumentHeader(file);
        if (header.getDocumentTitle() != null) {
            this.content.put("title", header.getDocumentTitle());
        }
        Map attributes = header.getAttributes();
        for (String key : attributes.keySet()) {
            if (key.equals("jbake-status")) {
                if (attributes.get(key) == null) continue;
                this.content.put("status", attributes.get(key));
                continue;
            }
            if (key.equals("jbake-type")) {
                if (attributes.get(key) == null) continue;
                this.content.put("type", attributes.get(key));
                continue;
            }
            if (key.equals("revdate")) {
                if (attributes.get(key) == null || !(attributes.get(key) instanceof String)) continue;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                Date date = null;
                try {
                    date = df.parse((String)attributes.get(key));
                    this.content.put("date", date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (key.equals("jbake-tags")) {
                if (attributes.get(key) == null || !(attributes.get(key) instanceof String)) continue;
                this.content.put("tags", ((String)attributes.get(key)).split(","));
                continue;
            }
            this.content.put(key, attributes.get(key));
        }
    }

    private void processBody(List<String> contents, File file) {
        StringBuffer body = new StringBuffer();
        boolean inBody = false;
        for (String line : contents) {
            if (inBody) {
                body.append(line + "\n");
            }
            if (!line.equals("~~~~~~")) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : contents) {
                body.append(line + "\n");
            }
        }
        if (file.getPath().endsWith(".md")) {
            MarkdownProcessor markdown = new MarkdownProcessor();
            this.content.put("body", markdown.markdown(body.toString()));
        } else if (file.getPath().endsWith(".ad") || file.getPath().endsWith(".asciidoc") || file.getPath().endsWith(".adoc")) {
            this.processAsciiDoc(body);
        } else {
            this.content.put("body", body.toString());
        }
    }

    private void processAsciiDoc(List<String> contents) {
        StringBuffer body = new StringBuffer();
        for (String line : contents) {
            body.append(line + "\n");
        }
        this.processAsciiDoc(body);
    }

    private void processAsciiDoc(StringBuffer contents) {
        Attributes attributes = AttributesBuilder.attributes((String)this.config.getString("asciidoctor.options")).get();
        Options options = OptionsBuilder.options().attributes(attributes).get();
        this.content.put("body", this.asciidoctor.render(contents.toString(), options));
    }
}

