/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.Asset;
import org.jbake.app.ConfigUtil;
import org.jbake.app.Crawler;
import org.jbake.app.FileUtil;
import org.jbake.app.Filter;
import org.jbake.app.Renderer;
import org.jbake.app.SortUtil;

public class Oven {
    private CompositeConfiguration config;
    private File source;
    private File destination;
    private File templatesPath;
    private File contentsPath;
    private File assetsPath;

    public Oven() {
    }

    public Oven(File source, File destination) throws Exception {
        this.source = source;
        this.destination = destination;
        this.config = ConfigUtil.load(source);
    }

    private void ensureSource() throws Exception {
        if (!FileUtil.isExistingFolder(this.source)) {
            throw new Exception("Error: Source folder must exist!");
        }
        if (!this.source.canRead()) {
            throw new Exception("Error: Source folder is not readable!");
        }
    }

    private void ensureDestination() throws Exception {
        if (null == this.destination) {
            this.destination = new File(this.config.getString("destination.folder"));
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        }
        if (!this.destination.canWrite()) {
            throw new Exception("Error: Destination folder is not writable!");
        }
    }

    public void setupPaths() throws Exception {
        this.ensureSource();
        this.templatesPath = this.setupRequiredFolderFromConfig("template.folder");
        this.contentsPath = this.setupRequiredFolderFromConfig("content.folder");
        this.assetsPath = this.setupPathFromConfig("asset.folder");
        if (!this.assetsPath.exists()) {
            System.out.println("Warning: No asset folder was found!");
        }
        this.ensureDestination();
    }

    private File setupPathFromConfig(String key) {
        return new File(this.source, this.config.getString(key));
    }

    private File setupRequiredFolderFromConfig(String key) throws Exception {
        File path = this.setupPathFromConfig(key);
        if (!FileUtil.isExistingFolder(path)) {
            throw new Exception("Error: Required folder cannot be found! Expected to find [" + key + "] at: " + path.getCanonicalPath());
        }
        return path;
    }

    public void bake() throws Exception {
        long start = new Date().getTime();
        System.out.println("Baking has started...");
        Crawler crawler = new Crawler(this.source, this.config);
        crawler.crawl(this.contentsPath);
        List<Map<String, Object>> pages = crawler.getPages();
        List<Map<String, Object>> posts = crawler.getPosts();
        Collections.sort(posts, SortUtil.getComparator(-1));
        Renderer renderer = new Renderer(this.source, this.destination, this.templatesPath, this.config, posts, pages);
        int renderedCount = 0;
        int errorCount = 0;
        for (Map<String, Object> page : pages) {
            try {
                renderer.render(page);
                ++renderedCount;
            }
            catch (Exception e) {
                ++errorCount;
            }
        }
        for (Map<String, Object> post : posts) {
            try {
                renderer.render(post);
                ++renderedCount;
            }
            catch (Exception e) {
                ++errorCount;
            }
        }
        List<Map<String, Object>> publishedPosts = Filter.getPublishedContent(posts);
        List<Map<String, Object>> publishedPages = Filter.getPublishedContent(pages);
        if (this.config.getBoolean("render.index")) {
            renderer.renderIndex(publishedPosts, this.config.getString("index.file"));
        }
        if (this.config.getBoolean("render.feed")) {
            renderer.renderFeed(publishedPosts, this.config.getString("feed.file"));
        }
        if (this.config.getBoolean("render.sitemap")) {
            renderer.renderSitemap(publishedPages, publishedPosts, this.config.getString("sitemap.file"));
        }
        if (this.config.getBoolean("render.archive")) {
            renderer.renderArchive(publishedPosts, this.config.getString("archive.file"));
        }
        if (this.config.getBoolean("render.tags")) {
            renderer.renderTags(crawler.getPostsByTags(), this.config.getString("tag.path"));
        }
        Asset asset = new Asset(this.source, this.destination);
        asset.copy(this.assetsPath);
        System.out.println("...finished!");
        long end = new Date().getTime();
        System.out.println("Baked " + renderedCount + " items in " + (end - start) + "ms");
        if (errorCount > 0) {
            System.out.println("Failed to bake " + errorCount + " item(s)!");
        }
    }
}

