/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Attributes;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.DocumentHeader;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.pegdown.PegDownProcessor;

public class Parser {
    private CompositeConfiguration config;
    private Map<String, Object> content = new HashMap<String, Object>();
    private Asciidoctor asciidoctor;
    private String currentPath;
    private DateFormat dateFormat;
    private PegDownProcessor pegdownProcessor;

    public Parser(CompositeConfiguration config, String contentPath) {
        this.config = config;
        this.dateFormat = new SimpleDateFormat(config.getString("date.format"));
        this.asciidoctor = Asciidoctor.Factory.create();
        String[] mdExts = config.getStringArray("markdown.extensions");
        if (mdExts.length > 0) {
            int extensions = 0;
            for (int index = 0; index < mdExts.length; ++index) {
                if (mdExts[index].equals("HARDWRAPS")) {
                    extensions |= 8;
                    continue;
                }
                if (mdExts[index].equals("AUTOLINKS")) {
                    extensions |= 0x10;
                    continue;
                }
                if (mdExts[index].equals("FENCED_CODE_BLOCKS")) {
                    extensions |= 0x80;
                    continue;
                }
                if (mdExts[index].equals("DEFINITIONS")) {
                    extensions |= 0x40;
                    continue;
                }
                if (mdExts[index].equals("ABBREVIATIONS")) {
                    extensions |= 4;
                    continue;
                }
                if (mdExts[index].equals("QUOTES")) {
                    extensions |= 2;
                    continue;
                }
                if (mdExts[index].equals("SMARTS")) {
                    extensions |= 1;
                    continue;
                }
                if (mdExts[index].equals("SMARTYPANTS")) {
                    extensions |= 3;
                    continue;
                }
                if (mdExts[index].equals("SUPPRESS_ALL_HTML")) {
                    extensions |= 0x30000;
                    continue;
                }
                if (mdExts[index].equals("SUPPRESS_HTML_BLOCKS")) {
                    extensions |= 0x10000;
                    continue;
                }
                if (mdExts[index].equals("SUPPRESS_INLINE_HTML")) {
                    extensions |= 0x20000;
                    continue;
                }
                if (mdExts[index].equals("TABLES")) {
                    extensions |= 0x20;
                    continue;
                }
                if (mdExts[index].equals("WIKILINKS")) {
                    extensions |= 0x100;
                    continue;
                }
                if (!mdExts[index].equals("ALL")) continue;
                extensions = 65535;
            }
            this.pegdownProcessor = new PegDownProcessor(extensions);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> processFile(File file) {
        this.content = new HashMap<String, Object>();
        this.currentPath = file.getParent();
        FileInputStream is = null;
        List fileContents = null;
        try {
            is = new FileInputStream(file);
            fileContents = IOUtils.readLines((InputStream)is, (String)this.config.getString("render.encoding"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        boolean hasHeader = this.hasHeader(fileContents);
        if (file.getPath().endsWith(".md") || file.getPath().endsWith(".html")) {
            if (hasHeader) {
                this.processHeader(fileContents);
                this.processBody(fileContents, file);
                return this.content;
            }
            System.err.println("Error parsing meta data from header!");
            return null;
        }
        if (!file.getPath().endsWith(".asciidoc") && !file.getPath().endsWith(".ad")) {
            if (!file.getPath().endsWith(".adoc")) return null;
        }
        if (hasHeader) {
            this.processHeader(fileContents);
            this.processBody(fileContents, file);
            return this.content;
        }
        if (this.validateAsciiDoc(file)) {
            this.processAsciiDocHeader(file);
            this.processAsciiDoc(fileContents);
            return this.content;
        }
        System.err.println("Error parsing meta data from header!");
        return null;
    }

    private boolean hasHeader(List<String> contents) {
        boolean headerValid = false;
        boolean headerSeparatorFound = false;
        boolean statusFound = false;
        boolean typeFound = false;
        ArrayList<String> header = new ArrayList<String>();
        for (String line : contents) {
            header.add(line);
            if (line.contains("=")) {
                if (line.startsWith("type=")) {
                    typeFound = true;
                }
                if (line.startsWith("status=")) {
                    statusFound = true;
                }
            }
            if (!line.equals("~~~~~~")) continue;
            headerSeparatorFound = true;
            header.remove(line);
            break;
        }
        if (headerSeparatorFound) {
            headerValid = true;
            for (String headerLine : header) {
                if (headerLine.contains("=")) continue;
                headerValid = false;
                break;
            }
        }
        return headerValid && statusFound && typeFound;
    }

    private void processHeader(List<String> contents) {
        for (String line : contents) {
            if (line.equals("~~~~~~")) break;
            String[] parts = line.split("=");
            if (parts.length != 2) continue;
            if (parts[0].equalsIgnoreCase("date")) {
                Date date = null;
                try {
                    date = this.dateFormat.parse(parts[1]);
                    this.content.put(parts[0], date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (parts[0].equalsIgnoreCase("tags")) {
                this.content.put(parts[0], parts[1].split(","));
                continue;
            }
            this.content.put(parts[0], parts[1]);
        }
    }

    private boolean validateAsciiDoc(File file) {
        DocumentHeader header = this.asciidoctor.readDocumentHeader(file);
        boolean statusFound = false;
        boolean typeFound = false;
        Set headerAttKeys = header.getAttributes().keySet();
        statusFound = headerAttKeys.contains("jbake-status");
        typeFound = headerAttKeys.contains("jbake-type");
        return statusFound && typeFound;
    }

    private void processAsciiDocHeader(File file) {
        DocumentHeader header = this.asciidoctor.readDocumentHeader(file);
        if (header.getDocumentTitle() != null) {
            this.content.put("title", header.getDocumentTitle());
        }
        Map attributes = header.getAttributes();
        for (String key : attributes.keySet()) {
            if (key.equals("jbake-status")) {
                if (attributes.get(key) == null) continue;
                this.content.put("status", attributes.get(key));
                continue;
            }
            if (key.equals("jbake-type")) {
                if (attributes.get(key) == null) continue;
                this.content.put("type", attributes.get(key));
                continue;
            }
            if (key.equals("revdate")) {
                if (attributes.get(key) == null || !(attributes.get(key) instanceof String)) continue;
                Date date = null;
                try {
                    date = this.dateFormat.parse((String)attributes.get(key));
                    this.content.put("date", date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (key.equals("jbake-tags")) {
                if (attributes.get(key) == null || !(attributes.get(key) instanceof String)) continue;
                this.content.put("tags", ((String)attributes.get(key)).split(","));
                continue;
            }
            this.content.put(key, attributes.get(key));
        }
    }

    private void processBody(List<String> contents, File file) {
        StringBuffer body = new StringBuffer();
        boolean inBody = false;
        for (String line : contents) {
            if (inBody) {
                body.append(line + "\n");
            }
            if (!line.equals("~~~~~~")) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : contents) {
                body.append(line + "\n");
            }
        }
        if (file.getPath().endsWith(".md")) {
            if (this.pegdownProcessor == null) {
                this.pegdownProcessor = new PegDownProcessor();
            }
            String markdown = this.pegdownProcessor.markdownToHtml(body.toString());
            this.content.put("body", markdown);
        } else if (file.getPath().endsWith(".ad") || file.getPath().endsWith(".asciidoc") || file.getPath().endsWith(".adoc")) {
            this.processAsciiDoc(body);
        } else {
            this.content.put("body", body.toString());
        }
    }

    private void processAsciiDoc(List<String> contents) {
        StringBuffer body = new StringBuffer();
        for (String line : contents) {
            body.append(line + "\n");
        }
        this.processAsciiDoc(body);
    }

    private void processAsciiDoc(StringBuffer contents) {
        Options options = this.getAsciiDocOptionsAndAttributes();
        this.content.put("body", this.asciidoctor.render(contents.toString(), options));
    }

    private Options getAsciiDocOptionsAndAttributes() {
        Attributes attributes = AttributesBuilder.attributes((String[])this.config.getStringArray("asciidoctor.attributes")).get();
        Configuration optionsSubset = this.config.subset("asciidoctor.option");
        Options options = OptionsBuilder.options().attributes(attributes).get();
        Iterator iterator = optionsSubset.getKeys();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            options.setOption(name, this.guessTypeByContent(optionsSubset.getString(name)));
        }
        options.setBaseDir(this.currentPath);
        options.setSafe(SafeMode.UNSAFE);
        return options;
    }

    private Object guessTypeByContent(String value) {
        if (BooleanUtils.toBooleanObject((String)value) != null) {
            return BooleanUtils.toBooleanObject((String)value);
        }
        if (NumberUtils.isNumber((String)value)) {
            return NumberUtils.toInt((String)value);
        }
        return value;
    }
}

