/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.Filter;

public class Renderer {
    private File destination;
    private Configuration templateCfg;
    private CompositeConfiguration config;
    private List<Map<String, Object>> posts;
    private List<Map<String, Object>> pages;

    public Renderer(File source, File destination, File templatesPath, CompositeConfiguration config) {
        this.destination = destination;
        this.config = config;
        this.templateCfg = new Configuration();
        this.templateCfg.setDefaultEncoding(config.getString("render.encoding"));
        try {
            this.templateCfg.setDirectoryForTemplateLoading(templatesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.templateCfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public Renderer(File source, File destination, File templatesPath, CompositeConfiguration config, List<Map<String, Object>> posts, List<Map<String, Object>> pages) {
        this(source, destination, templatesPath, config);
        this.posts = posts;
        this.pages = pages;
    }

    private void render(Map<String, Object> model, String templateFilename, File outputFile) throws Exception {
        model.put("version", this.config.getString("version"));
        model.put("posts", this.posts);
        model.put("pages", this.pages);
        HashMap<String, Object> configModel = new HashMap<String, Object>();
        Iterator configKeys = this.config.getKeys();
        while (configKeys.hasNext()) {
            String key = (String)configKeys.next();
            configModel.put(key.replace(".", "_"), this.config.getProperty(key));
        }
        model.put("config", configModel);
        Template template = null;
        template = this.templateCfg.getTemplate(templateFilename);
        if (!outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
            outputFile.createNewFile();
        }
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), this.config.getString("render.encoding"));
        template.process(model, (Writer)out);
        ((Writer)out).close();
    }

    public void render(Map<String, Object> content) throws Exception {
        File publishedFile;
        String outputFilename = this.destination.getPath() + (String)content.get("uri");
        File draftFile = new File((outputFilename = outputFilename.substring(0, outputFilename.lastIndexOf("."))) + this.config.getString("draft.suffix") + this.config.getString("output.extension"));
        if (draftFile.exists()) {
            draftFile.delete();
        }
        if ((publishedFile = new File(outputFilename + this.config.getString("output.extension"))).exists()) {
            publishedFile.delete();
        }
        if (content.get("status").equals("draft")) {
            outputFilename = outputFilename + this.config.getString("draft.suffix");
        }
        File outputFile = new File(outputFilename + this.config.getString("output.extension"));
        System.out.print("Rendering [" + outputFile + "]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", content);
        try {
            this.render(model, (String)content.get("type") + ".ftl", outputFile);
            System.out.println("done!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed!");
            throw new Exception("Failed to render file");
        }
    }

    public void renderIndex(List<Map<String, Object>> posts, String indexFile) {
        File outputFile = new File(this.destination.getPath() + File.separator + indexFile);
        System.out.print("Rendering index [" + outputFile + "]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("published_posts", posts);
        try {
            this.render(model, this.config.getString("template.index.file"), outputFile);
            System.out.println("done!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed!");
        }
    }

    public void renderFeed(List<Map<String, Object>> posts, String feedFile) {
        File outputFile = new File(this.destination.getPath() + File.separator + feedFile);
        System.out.print("Rendering feed [" + outputFile + "]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("published_posts", posts);
        model.put("published_date", new Date());
        try {
            this.render(model, this.config.getString("template.feed.file"), outputFile);
            System.out.println("done!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed!");
        }
    }

    public void renderSitemap(List<Map<String, Object>> pages, List<Map<String, Object>> posts, String sitemapFile) {
        File outputFile = new File(this.destination.getPath() + File.separator + sitemapFile);
        System.out.print("Rendering sitemap [" + outputFile + "]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("published_pages", pages);
        model.put("published_posts", posts);
        try {
            this.render(model, this.config.getString("template.sitemap.file"), outputFile);
            System.out.println("done!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed!");
        }
    }

    public void renderArchive(List<Map<String, Object>> posts, String archiveFile) {
        File outputFile = new File(this.destination.getPath() + File.separator + archiveFile);
        System.out.print("Rendering archive [" + outputFile + "]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("published_posts", posts);
        try {
            this.render(model, this.config.getString("template.archive.file"), outputFile);
            System.out.println("done!");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed!");
        }
    }

    public void renderTags(Map<String, List<Map<String, Object>>> tags, String tagPath) {
        for (String tag : tags.keySet()) {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("tag", tag);
            List<Map<String, Object>> posts = Filter.getPublishedContent(tags.get(tag));
            model.put("tag_posts", posts);
            tag = tag.trim().replace(" ", "-");
            File outputFile = new File(this.destination.getPath() + File.separator + tagPath + File.separator + tag + this.config.getString("output.extension"));
            System.out.print("Rendering tags [" + outputFile + "]... ");
            try {
                this.render(model, this.config.getString("template.tag.file"), outputFile);
                System.out.println("done!");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("failed!");
            }
        }
    }
}

