/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ZipUtil;

public class Init {
    private CompositeConfiguration config;

    public Init(CompositeConfiguration config) {
        this.config = config;
    }

    public void run(File outputFolder, File templateLocationFolder) throws Exception {
        if (!outputFolder.canWrite()) {
            throw new Exception("Output folder is not writeable!");
        }
        File[] contents = outputFolder.listFiles();
        boolean safe = true;
        if (contents != null) {
            for (File content : contents) {
                if (!content.isDirectory()) continue;
                if (content.getName().equalsIgnoreCase(this.config.getString("template.folder"))) {
                    safe = false;
                }
                if (content.getName().equalsIgnoreCase(this.config.getString("content.folder"))) {
                    safe = false;
                }
                if (!content.getName().equalsIgnoreCase(this.config.getString("asset.folder"))) continue;
                safe = false;
            }
        }
        if (!safe) {
            throw new Exception("Output folder already contains structure!");
        }
        File templateFile = new File(templateLocationFolder, this.config.getString("base.template"));
        if (!templateFile.exists()) {
            throw new Exception("Cannot locate template file: " + templateFile.getPath());
        }
        ZipUtil.extract(new FileInputStream(templateFile), outputFolder);
    }
}

