/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.DBUtil;
import org.jbake.app.FileUtil;
import org.jbake.app.Parser;
import org.jbake.model.DocumentStatus;
import org.jbake.model.DocumentTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    private CompositeConfiguration config;
    private Parser parser;
    private final ODatabaseDocumentTx db;
    private String contentPath;

    public Crawler(ODatabaseDocumentTx db, File source, CompositeConfiguration config) {
        this.db = db;
        this.config = config;
        this.contentPath = source.getPath() + File.separator + config.getString("content.folder");
        this.parser = new Parser(config, this.contentPath);
    }

    public void crawl(File path) {
        Object[] contents = path.listFiles(FileUtil.getFileFilter());
        if (contents != null) {
            Arrays.sort(contents);
            for (Object sourceFile : contents) {
                if (((File)sourceFile).isFile()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Processing [").append(((File)sourceFile).getPath()).append("]... ");
                    String sha1 = this.buildHash((File)sourceFile);
                    String uri = this.buildURI((File)sourceFile);
                    boolean process = true;
                    DocumentStatus status = DocumentStatus.NEW;
                    for (String docType : DocumentTypes.getDocumentTypes()) {
                        status = this.findDocumentStatus(docType, uri, sha1);
                        switch (status) {
                            case UPDATED: {
                                sb.append(" : modified ");
                                DBUtil.update(this.db, "delete from " + docType + " where uri=?", uri);
                                break;
                            }
                            case IDENTICAL: {
                                sb.append(" : same ");
                                process = false;
                            }
                        }
                        if (!process) break;
                    }
                    if (DocumentStatus.NEW == status) {
                        sb.append(" : new ");
                    }
                    if (process) {
                        this.crawlSourceFile((File)sourceFile, sha1, uri);
                    }
                    LOGGER.info(sb.toString());
                }
                if (!((File)sourceFile).isDirectory()) continue;
                this.crawl((File)sourceFile);
            }
        }
    }

    private String buildHash(File sourceFile) {
        String sha1;
        try {
            sha1 = FileUtil.sha1(sourceFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            sha1 = "";
        }
        return sha1;
    }

    private String buildURI(File sourceFile) {
        String uri = FileUtil.asPath(sourceFile.getPath()).replace(FileUtil.asPath(this.contentPath), "");
        if (uri.startsWith("/")) {
            uri = uri.substring(1, uri.length());
        }
        uri = uri.substring(0, uri.lastIndexOf(".")) + this.config.getString("output.extension");
        return uri;
    }

    private void crawlSourceFile(File sourceFile, String sha1, String uri) {
        Map<String, Object> fileContents = this.parser.processFile(sourceFile);
        if (fileContents != null) {
            fileContents.put("rootpath", this.getPathToRoot(sourceFile));
            fileContents.put("sha1", sha1);
            fileContents.put("rendered", false);
            if (fileContents.get("tags") != null) {
                String[] tags = (String[])fileContents.get("tags");
                fileContents.put("tags", tags);
            }
            fileContents.put("file", sourceFile.getPath());
            fileContents.put("uri", uri);
            String documentType = (String)fileContents.get("type");
            if (fileContents.get("status").equals("published-date") && fileContents.get("date") != null && fileContents.get("date") instanceof Date && new Date().after((Date)fileContents.get("date"))) {
                fileContents.put("status", "published");
            }
            ODocument doc = new ODocument(documentType);
            doc.fields(fileContents);
            boolean cached = fileContents.get("cached") != null ? Boolean.valueOf((String)fileContents.get("cached")) : true;
            doc.field("cached", (Object)cached);
            doc.save();
        } else {
            LOGGER.warn("{} has an invalid header, it has been ignored!", (Object)sourceFile);
        }
    }

    public String getPathToRoot(File sourceFile) {
        File rootPath = new File(this.contentPath);
        File parentPath = sourceFile.getParentFile();
        int parentCount = 0;
        while (!parentPath.equals(rootPath)) {
            parentPath = parentPath.getParentFile();
            ++parentCount;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parentCount; ++i) {
            sb.append("../");
        }
        return sb.toString();
    }

    public int getDocumentCount(String docType) {
        return (int)this.db.countClass(docType);
    }

    public int getPostCount() {
        return this.getDocumentCount("post");
    }

    public int getPageCount() {
        return this.getDocumentCount("page");
    }

    public Set<String> getTags() {
        List query = this.db.query((OQuery)new OSQLSynchQuery("select tags from post where status='published'"), new Object[0]);
        HashSet<String> result = new HashSet<String>();
        for (ODocument document : query) {
            String[] tags = DBUtil.toStringArray(document.field("tags"));
            Collections.addAll(result, tags);
        }
        return result;
    }

    private DocumentStatus findDocumentStatus(String docType, String uri, String sha1) {
        List<ODocument> match = DBUtil.query(this.db, "select sha1,rendered from " + docType + " where uri=?", uri);
        if (!match.isEmpty()) {
            ODocument entries = match.get(0);
            String oldHash = (String)entries.field("sha1");
            if (!oldHash.equals(sha1) || Boolean.FALSE.equals(entries.field("rendered"))) {
                return DocumentStatus.UPDATED;
            }
            return DocumentStatus.IDENTICAL;
        }
        return DocumentStatus.NEW;
    }
}

