/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.Asset;
import org.jbake.app.ConfigUtil;
import org.jbake.app.Crawler;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentIterator;
import org.jbake.app.FileUtil;
import org.jbake.app.Renderer;
import org.jbake.model.DocumentTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oven {
    private static final Logger LOGGER = LoggerFactory.getLogger(Oven.class);
    private static final Pattern TEMPLATE_DOC_PATTERN = Pattern.compile("(?:template\\.)([a-zA-Z0-9]+)(?:\\.file)");
    private CompositeConfiguration config;
    private File source;
    private File destination;
    private File templatesPath;
    private File contentsPath;
    private File assetsPath;
    private boolean isClearCache;
    private List<String> errors = new LinkedList<String>();
    private int renderedCount = 0;

    public Oven(File source, File destination, boolean isClearCache) throws Exception {
        this.source = source;
        this.destination = destination;
        this.config = ConfigUtil.load(source);
        this.isClearCache = isClearCache;
    }

    public CompositeConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CompositeConfiguration config) {
        this.config = config;
    }

    private void ensureSource() throws Exception {
        if (!FileUtil.isExistingFolder(this.source)) {
            throw new Exception("Error: Source folder must exist!");
        }
        if (!this.source.canRead()) {
            throw new Exception("Error: Source folder is not readable!");
        }
    }

    private void ensureDestination() throws Exception {
        if (null == this.destination) {
            this.destination = new File(this.config.getString("destination.folder"));
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        }
        if (!this.destination.canWrite()) {
            throw new Exception("Error: Destination folder is not writable!");
        }
    }

    public void setupPaths() throws Exception {
        this.ensureSource();
        this.templatesPath = this.setupRequiredFolderFromConfig("template.folder");
        this.contentsPath = this.setupRequiredFolderFromConfig("content.folder");
        this.assetsPath = this.setupPathFromConfig("asset.folder");
        if (!this.assetsPath.exists()) {
            LOGGER.warn("No asset folder was found!");
        }
        this.ensureDestination();
    }

    private File setupPathFromConfig(String key) {
        return new File(this.source, this.config.getString(key));
    }

    private File setupRequiredFolderFromConfig(String key) throws Exception {
        File path = this.setupPathFromConfig(key);
        if (!FileUtil.isExistingFolder(path)) {
            throw new Exception("Error: Required folder cannot be found! Expected to find [" + key + "] at: " + path.getCanonicalPath());
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bake() throws Exception {
        ODatabaseDocumentTx db = DBUtil.createDB(this.config.getString("db.store"), this.config.getString("db.path"));
        this.updateDocTypesFromConfiguration();
        DBUtil.updateSchema(db);
        try {
            long start = new Date().getTime();
            LOGGER.info("Baking has started...");
            this.clearCacheIfNeeded(db);
            Crawler crawler = new Crawler(db, this.source, this.config);
            crawler.crawl(this.contentsPath);
            LOGGER.info("Pages : {}", (Object)crawler.getPageCount());
            LOGGER.info("Posts : {}", (Object)crawler.getPostCount());
            Renderer renderer = new Renderer(db, this.destination, this.templatesPath, this.config);
            for (String docType : DocumentTypes.getDocumentTypes()) {
                DocumentIterator pagesIt = DBUtil.fetchDocuments(db, "select * from " + docType + " where rendered=false", new Object[0]);
                while (pagesIt.hasNext()) {
                    Object page = pagesIt.next();
                    try {
                        renderer.render((Map<String, Object>)page);
                        ++this.renderedCount;
                    }
                    catch (Exception e) {
                        this.errors.add(e.getMessage());
                    }
                }
            }
            if (this.config.getBoolean("render.index")) {
                try {
                    renderer.renderIndex(this.config.getString("index.file"));
                }
                catch (Exception e) {
                    this.errors.add(e.getMessage());
                }
            }
            if (this.config.getBoolean("render.feed")) {
                try {
                    renderer.renderFeed(this.config.getString("feed.file"));
                }
                catch (Exception e) {
                    this.errors.add(e.getMessage());
                }
            }
            if (this.config.getBoolean("render.sitemap")) {
                try {
                    renderer.renderSitemap(this.config.getString("sitemap.file"));
                }
                catch (Exception e) {
                    this.errors.add(e.getMessage());
                }
            }
            if (this.config.getBoolean("render.archive")) {
                try {
                    renderer.renderArchive(this.config.getString("archive.file"));
                }
                catch (Exception e) {
                    this.errors.add(e.getMessage());
                }
            }
            if (this.config.getBoolean("render.tags")) {
                try {
                    renderer.renderTags(crawler.getTags(), this.config.getString("tag.path"));
                }
                catch (Exception e) {
                    this.errors.add(e.getMessage());
                }
            }
            for (String docType : DocumentTypes.getDocumentTypes()) {
                DBUtil.update(db, "update " + docType + " set rendered=true where rendered=false and cached=true", new Object[0]);
            }
            Asset asset = new Asset(this.source, this.destination);
            asset.copy(this.assetsPath);
            this.errors.addAll(asset.getErrors());
            LOGGER.info("Baking finished!");
            long end = new Date().getTime();
            LOGGER.info("Baked {} items in {}ms", (Object)this.renderedCount, (Object)(end - start));
            if (this.errors.size() > 0) {
                LOGGER.error("Failed to bake {} item(s)!", (Object)this.errors.size());
            }
        }
        finally {
            db.close();
        }
    }

    private void updateDocTypesFromConfiguration() {
        Iterator keyIterator = this.config.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Matcher matcher = TEMPLATE_DOC_PATTERN.matcher(key);
            if (!matcher.find()) continue;
            DocumentTypes.addDocumentType(matcher.group(1));
        }
    }

    private void clearCacheIfNeeded(ODatabaseDocumentTx db) {
        boolean needed = this.isClearCache;
        if (!needed) {
            String currentTemplatesSignature;
            List<ODocument> docs = DBUtil.query(db, "select sha1 from Signatures where key='templates'", new Object[0]);
            try {
                currentTemplatesSignature = FileUtil.sha1(this.templatesPath);
            }
            catch (Exception e) {
                currentTemplatesSignature = "";
            }
            if (!docs.isEmpty()) {
                String sha1 = (String)docs.get(0).field("sha1");
                boolean bl = needed = !sha1.equals(currentTemplatesSignature);
                if (needed) {
                    DBUtil.update(db, "update Signatures set sha1=? where key='templates'", currentTemplatesSignature);
                }
            } else {
                DBUtil.update(db, "insert into Signatures(key,sha1) values('templates',?)", currentTemplatesSignature);
                needed = true;
            }
        }
        if (needed) {
            for (String docType : DocumentTypes.getDocumentTypes()) {
                try {
                    DBUtil.update(db, "delete from " + docType, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            DBUtil.updateSchema(db);
        }
    }

    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }
}

