/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.IOUtils;
import org.jbake.app.FileUtil;
import org.jbake.parser.Engines;
import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Parser.class);
    private CompositeConfiguration config;
    private String contentPath;

    public Parser(CompositeConfiguration config, String contentPath) {
        this.config = config;
        this.contentPath = contentPath;
    }

    public Map<String, Object> processFile(File file) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        FileInputStream is = null;
        List fileContents = null;
        try {
            is = new FileInputStream(file);
            fileContents = IOUtils.readLines((InputStream)is, (String)this.config.getString("render.encoding"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        boolean hasHeader = this.hasHeader(fileContents);
        ParserContext context = new ParserContext(file, fileContents, this.config, this.contentPath, hasHeader, content);
        MarkupEngine engine = Engines.get(FileUtil.fileExt(file));
        if (engine == null) {
            LOGGER.error("Unable to find suitable markup engine for {}", (Object)file);
            return null;
        }
        if (hasHeader) {
            this.processHeader(fileContents, content);
        }
        engine.processHeader(context);
        if (this.config.getString("default.status") != null && content.get("status") == null) {
            content.put("status", this.config.getString("default.status"));
        }
        if (content.get("type") == null || content.get("status") == null) {
            LOGGER.error("Error parsing meta data from header!");
            return null;
        }
        this.processBody(fileContents, content);
        if (!engine.validate(context)) {
            LOGGER.error("Incomplete source file ({}) for markup engine:", (Object)file, (Object)engine.getClass().getSimpleName());
            return null;
        }
        engine.processBody(context);
        return content;
    }

    private boolean hasHeader(List<String> contents) {
        boolean headerValid = false;
        boolean headerSeparatorFound = false;
        boolean statusFound = false;
        boolean typeFound = false;
        ArrayList<String> header = new ArrayList<String>();
        for (String line : contents) {
            header.add(line);
            if (line.contains("=")) {
                if (line.startsWith("type=")) {
                    typeFound = true;
                }
                if (line.startsWith("status=")) {
                    statusFound = true;
                }
            }
            if (!line.equals("~~~~~~")) continue;
            headerSeparatorFound = true;
            header.remove(line);
            break;
        }
        if (headerSeparatorFound) {
            headerValid = true;
            for (String headerLine : header) {
                if (headerLine.contains("=")) continue;
                headerValid = false;
                break;
            }
        }
        return headerValid && statusFound && typeFound;
    }

    private void processHeader(List<String> contents, Map<String, Object> content) {
        for (String line : contents) {
            if (line.equals("~~~~~~")) break;
            String[] parts = line.split("=");
            if (parts.length != 2) continue;
            if (parts[0].equalsIgnoreCase("date")) {
                SimpleDateFormat df = new SimpleDateFormat(this.config.getString("date.format"));
                Date date = null;
                try {
                    date = df.parse(parts[1]);
                    content.put(parts[0], date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (parts[0].equalsIgnoreCase("tags")) {
                content.put(parts[0], parts[1].split(","));
                continue;
            }
            content.put(parts[0], parts[1]);
        }
    }

    private void processBody(List<String> contents, Map<String, Object> content) {
        StringBuilder body = new StringBuilder();
        boolean inBody = false;
        for (String line : contents) {
            if (inBody) {
                body.append(line).append("\n");
            }
            if (!line.equals("~~~~~~")) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : contents) {
                body.append(line).append("\n");
            }
        }
        content.put("body", body.toString());
    }
}

