/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.jbake.app.ConfigUtil;
import org.jbake.app.FileUtil;
import org.jbake.app.Oven;
import org.jbake.launcher.Init;
import org.jbake.launcher.JettyServer;
import org.jbake.launcher.LaunchOptions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class Main {
    private final String USAGE_PREFIX = "Usage: jbake";
    private final String ALT_USAGE_PREFIX = "   or  jbake";

    public static void main(String[] args) {
        new Main().run(args);
    }

    private void bake(LaunchOptions options) {
        try {
            Oven oven = new Oven(options.getSource(), options.getDestination(), options.isClearCache());
            oven.setupPaths();
            oven.bake();
            List<String> errors = oven.getErrors();
            if (!errors.isEmpty()) {
                System.err.println(MessageFormat.format("JBake failed with {0} errors:", errors.size()));
                int errNr = 1;
                for (String msg : errors) {
                    System.err.println(MessageFormat.format("{0}. {1}", errNr, msg));
                    ++errNr;
                }
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run(String[] args) {
        LaunchOptions res = this.parseArguments(args);
        CompositeConfiguration config = null;
        try {
            config = ConfigUtil.load(res.getSource());
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("JBake " + config.getString("version") + " (" + config.getString("build.timestamp") + ") [http://jbake.org]");
        System.out.println();
        if (res.isHelpNeeded()) {
            this.printUsage(res);
        }
        if (res.isBake()) {
            this.bake(res);
        }
        if (res.isInit()) {
            if (res.getSourceValue() != null) {
                this.initStructure(config, res.getSourceValue());
            } else {
                this.initStructure(config, "freemarker");
            }
        }
        if (res.isRunServer()) {
            if (res.getSource().getPath().equals(".")) {
                this.runServer(config.getString("destination.folder"), config.getString("server.port"));
            } else {
                this.runServer(res.getSource().getPath(), config.getString("server.port"));
            }
        }
    }

    private LaunchOptions parseArguments(String[] args) {
        LaunchOptions res = new LaunchOptions();
        CmdLineParser parser = new CmdLineParser((Object)res);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.printUsage(res);
        }
        return res;
    }

    private void printUsage(Object options) {
        CmdLineParser parser = new CmdLineParser(options);
        StringWriter sw = new StringWriter();
        sw.append("Usage: jbake\n");
        sw.append("   or  jbake <source> <destination>\n");
        sw.append("   or  jbake [OPTION]... [<value>...]\n\n");
        sw.append("Options:");
        System.out.println(sw.toString());
        parser.setUsageWidth(100);
        parser.printUsage((OutputStream)System.out);
        System.exit(0);
    }

    private void runServer(String path, String port) {
        JettyServer.run(path, port);
        System.exit(0);
    }

    private void initStructure(CompositeConfiguration config, String type) {
        Init init = new Init(config);
        try {
            File codeFolder = FileUtil.getRunningLocation();
            init.run(new File("."), codeFolder, type);
            System.out.println("Base folder structure successfully created.");
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println("Failed to initalise structure!");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

