/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.AttributesBuilder;
import org.asciidoctor.DocumentHeader;
import org.asciidoctor.Options;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;
import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciidoctorEngine
extends MarkupEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciidoctorEngine.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Asciidoctor engine;

    public AsciidoctorEngine() {
        Class<Asciidoctor> engineClass = Asciidoctor.class;
        assert (engineClass != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Asciidoctor getEngine() {
        block7: {
            try {
                this.lock.readLock().lock();
                if (this.engine != null) break block7;
                this.lock.readLock().unlock();
                try {
                    this.lock.writeLock().lock();
                    if (this.engine == null) {
                        LOGGER.info("Initializing Asciidoctor engine...");
                        this.engine = Asciidoctor.Factory.create();
                        LOGGER.info("Asciidoctor engine initialized.");
                    }
                }
                finally {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return this.engine;
    }

    @Override
    public void processHeader(ParserContext context) {
        Asciidoctor asciidoctor = this.getEngine();
        DocumentHeader header = asciidoctor.readDocumentHeader(context.getFile());
        Map<String, Object> contents = context.getContents();
        if (header.getDocumentTitle() != null) {
            contents.put("title", header.getDocumentTitle());
        }
        Map attributes = header.getAttributes();
        for (String key : attributes.keySet()) {
            Object val;
            if (key.startsWith("jbake-") && (val = attributes.get(key)) != null) {
                String pKey = key.substring(6);
                contents.put(pKey, val);
            }
            if (key.equals("revdate") && attributes.get(key) != null && attributes.get(key) instanceof String) {
                SimpleDateFormat df = new SimpleDateFormat(context.getConfig().getString("date.format"));
                Date date = null;
                try {
                    date = df.parse((String)attributes.get(key));
                    contents.put("date", date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            if (key.equals("jbake-tags")) {
                if (attributes.get(key) == null || !(attributes.get(key) instanceof String)) continue;
                contents.put("tags", ((String)attributes.get(key)).split(","));
                continue;
            }
            contents.put(key, attributes.get(key));
        }
    }

    @Override
    public void processBody(ParserContext context) {
        StringBuilder body = new StringBuilder(context.getBody().length());
        if (!context.hasHeader()) {
            for (String line : context.getFileLines()) {
                body.append(line).append("\n");
            }
            context.setBody(body.toString());
        }
        this.processAsciiDoc(context);
    }

    private void processAsciiDoc(ParserContext context) {
        Asciidoctor asciidoctor = this.getEngine();
        Options options = this.getAsciiDocOptionsAndAttributes(context);
        context.setBody(asciidoctor.render(context.getBody(), options));
    }

    private Options getAsciiDocOptionsAndAttributes(ParserContext context) {
        CompositeConfiguration config = context.getConfig();
        AttributesBuilder attributes = AttributesBuilder.attributes((String[])config.getStringArray("asciidoctor.attributes"));
        if (config.getBoolean("asciidoctor.attributes.export", false)) {
            String prefix = config.getString("asciidoctor.attributes.export.prefix", "");
            Iterator it = config.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (key.startsWith("asciidoctor")) continue;
                attributes.attribute(prefix + key.replace(".", "_"), config.getProperty(key));
            }
        }
        Configuration optionsSubset = config.subset("asciidoctor.option");
        Options options = OptionsBuilder.options().attributes(attributes.get()).get();
        Iterator iterator = optionsSubset.getKeys();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            options.setOption(name, AsciidoctorEngine.guessTypeByContent(optionsSubset.getString(name)));
        }
        options.setBaseDir(context.getFile().getParent());
        options.setSafe(SafeMode.UNSAFE);
        return options;
    }

    private static Object guessTypeByContent(String value) {
        if (BooleanUtils.toBooleanObject((String)value) != null) {
            return BooleanUtils.toBooleanObject((String)value);
        }
        if (NumberUtils.isNumber((String)value)) {
            return NumberUtils.toInt((String)value);
        }
        return value;
    }
}

