/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asset {
    private static final Logger LOGGER = LoggerFactory.getLogger(Asset.class);
    private File source;
    private File destination;
    private final List<String> errors = new LinkedList<String>();

    public Asset(File source, File destination) {
        this.source = source;
        this.destination = destination;
    }

    public void copy(File path) {
        Object[] assets = path.listFiles();
        if (assets != null) {
            Arrays.sort(assets);
            for (int i = 0; i < assets.length; ++i) {
                if (((File)assets[i]).isFile()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Copying [" + ((File)assets[i]).getPath() + "]...");
                    Object sourceFile = assets[i];
                    File destFile = new File(((File)sourceFile).getPath().replace(this.source.getPath() + File.separator + "assets", this.destination.getPath()));
                    try {
                        FileUtils.copyFile((File)sourceFile, (File)destFile);
                        sb.append("done!");
                        LOGGER.info(sb.toString());
                    }
                    catch (IOException e) {
                        sb.append("failed!");
                        LOGGER.error(sb.toString(), (Throwable)e);
                        e.printStackTrace();
                        this.errors.add(e.getMessage());
                    }
                }
                if (!((File)assets[i]).isDirectory()) continue;
                this.copy((File)assets[i]);
            }
        }
    }

    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }
}

