/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbake.app.DocumentIterator;
import org.jbake.model.DocumentTypes;

public class DBUtil {
    public static ODatabaseDocumentTx createDB(String type, String name) {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(type + ":" + name);
        boolean exists = db.exists();
        if (!exists) {
            db.create();
        }
        db = (ODatabaseDocumentTx)ODatabaseDocumentPool.global().acquire(type + ":" + name, "admin", "admin");
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)db);
        if (!exists) {
            DBUtil.updateSchema(db);
        }
        return db;
    }

    public static void updateSchema(ODatabaseDocumentTx db) {
        OSchema schema = db.getMetadata().getSchema();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            if (schema.getClass(docType) != null) continue;
            DBUtil.createDocType(schema, docType);
        }
        if (schema.getClass("Signatures") == null) {
            OClass signatures = schema.createClass("Signatures");
            signatures.createProperty("key", OType.STRING).setNotNull(true);
            signatures.createProperty("sha1", OType.STRING).setNotNull(true);
        }
    }

    private static void createDocType(OSchema schema, String doctype) {
        OClass page = schema.createClass(doctype);
        page.createProperty("sha1", OType.STRING).setNotNull(true);
        page.createProperty("uri", OType.STRING).setNotNull(true);
        page.createProperty("rendered", OType.BOOLEAN).setNotNull(true);
        page.createProperty("cached", OType.BOOLEAN).setNotNull(true);
    }

    public static Map<String, Object> documentToModel(ODocument doc) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : doc) {
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static List<ODocument> query(ODatabaseDocumentTx db, String query, Object ... args) {
        return (List)db.command((OCommandRequest)new OSQLSynchQuery(query)).execute(args);
    }

    public static void update(ODatabaseDocumentTx db, String query, Object ... args) {
        db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
    }

    public static DocumentIterator fetchDocuments(ODatabaseDocumentTx db, String query, Object ... args) {
        return new DocumentIterator(DBUtil.query(db, query, args).iterator());
    }

    public static String[] toStringArray(Object entry) {
        if (entry instanceof String[]) {
            return (String[])entry;
        }
        if (entry instanceof OTrackedList) {
            OTrackedList list = (OTrackedList)entry;
            return (String[])list.toArray((Object[])new String[list.size()]);
        }
        throw new IllegalArgumentException("Unable to convert object to String[]");
    }
}

