/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.pegdown.PegDownProcessor;

public class MarkdownEngine
extends MarkupEngine {
    public MarkdownEngine() {
        Class<PegDownProcessor> engineClass = PegDownProcessor.class;
        assert (engineClass != null);
    }

    @Override
    public void processBody(ParserContext context) {
        String[] mdExts = context.getConfig().getStringArray("markdown.extensions");
        int extensions = 0;
        if (mdExts.length > 0) {
            for (int index = 0; index < mdExts.length; ++index) {
                if (mdExts[index].equals("HARDWRAPS")) {
                    extensions |= 8;
                    continue;
                }
                if (mdExts[index].equals("AUTOLINKS")) {
                    extensions |= 0x10;
                    continue;
                }
                if (mdExts[index].equals("FENCED_CODE_BLOCKS")) {
                    extensions |= 0x80;
                    continue;
                }
                if (mdExts[index].equals("DEFINITIONS")) {
                    extensions |= 0x40;
                    continue;
                }
                if (mdExts[index].equals("ABBREVIATIONS")) {
                    extensions |= 4;
                    continue;
                }
                if (mdExts[index].equals("QUOTES")) {
                    extensions |= 2;
                    continue;
                }
                if (mdExts[index].equals("SMARTS")) {
                    extensions |= 1;
                    continue;
                }
                if (mdExts[index].equals("SMARTYPANTS")) {
                    extensions |= 3;
                    continue;
                }
                if (mdExts[index].equals("SUPPRESS_ALL_HTML")) {
                    extensions |= 0x30000;
                    continue;
                }
                if (mdExts[index].equals("SUPPRESS_HTML_BLOCKS")) {
                    extensions |= 0x10000;
                    continue;
                }
                if (mdExts[index].equals("SUPPRESS_INLINE_HTML")) {
                    extensions |= 0x20000;
                    continue;
                }
                if (mdExts[index].equals("TABLES")) {
                    extensions |= 0x20;
                    continue;
                }
                if (mdExts[index].equals("WIKILINKS")) {
                    extensions |= 0x100;
                    continue;
                }
                if (!mdExts[index].equals("ALL")) continue;
                extensions = 65535;
            }
        }
        long maxParsingTime = context.getConfig().getLong("markdown.maxParsingTimeInMillis", 2000L);
        PegDownProcessor pegdownProcessor = new PegDownProcessor(extensions, maxParsingTime);
        context.setBody(pegdownProcessor.markdownToHtml(context.getBody()));
    }
}

