/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.template.AbstractTemplateEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateEngines.class);
    private final Map<String, AbstractTemplateEngine> templateEngines = new HashMap<String, AbstractTemplateEngine>();

    public Set<String> getRecognizedExtensions() {
        return Collections.unmodifiableSet(this.templateEngines.keySet());
    }

    public TemplateEngines(CompositeConfiguration config, ODatabaseDocumentTx db, File destination, File templatesPath) {
        this.loadEngines(config, db, destination, templatesPath);
    }

    private void registerEngine(String fileExtension, AbstractTemplateEngine templateEngine) {
        AbstractTemplateEngine old = this.templateEngines.put(fileExtension, templateEngine);
        if (old != null) {
            LOGGER.warn("Registered a template engine for extension [.{}] but another one was already defined: {}", (Object)fileExtension, (Object)old);
        }
    }

    public AbstractTemplateEngine getEngine(String fileExtension) {
        return this.templateEngines.get(fileExtension);
    }

    private static AbstractTemplateEngine tryLoadEngine(CompositeConfiguration config, ODatabaseDocumentTx db, File destination, File templatesPath, String engineClassName) {
        try {
            Class<?> engineClass = Class.forName(engineClassName, false, TemplateEngines.class.getClassLoader());
            Constructor<?> ctor = engineClass.getConstructor(CompositeConfiguration.class, ODatabaseDocumentTx.class, File.class, File.class);
            return (AbstractTemplateEngine)ctor.newInstance(config, db, destination, templatesPath);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private void loadEngines(CompositeConfiguration config, ODatabaseDocumentTx db, File destination, File templatesPath) {
        try {
            ClassLoader cl = TemplateEngines.class.getClassLoader();
            Enumeration<URL> resources = cl.getResources("META-INF/org.jbake.parser.TemplateEngines.properties");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                Properties props = new Properties();
                props.load(url.openStream());
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String className = (String)entry.getKey();
                    String[] extensions = ((String)entry.getValue()).split(",");
                    this.registerEngine(config, db, destination, templatesPath, className, extensions);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void registerEngine(CompositeConfiguration config, ODatabaseDocumentTx db, File destination, File templatesPath, String className, String ... extensions) {
        AbstractTemplateEngine engine = TemplateEngines.tryLoadEngine(config, db, destination, templatesPath, className);
        if (engine != null) {
            for (String extension : extensions) {
                this.registerEngine(extension, engine);
            }
        }
    }
}

