/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import org.jbake.model.DocumentTypes;

public class ContentStore {
    private ODatabaseDocumentTx db;

    public ContentStore(String type, String name) {
        this.db = new ODatabaseDocumentTx(type + ":" + name);
        boolean exists = this.db.exists();
        if (!exists) {
            this.db.create();
        }
        this.db = (ODatabaseDocumentTx)ODatabaseDocumentPool.global().acquire(type + ":" + name, "admin", "admin");
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.db);
        if (!exists) {
            this.updateSchema();
        }
    }

    public final void updateSchema() {
        OSchema schema = this.db.getMetadata().getSchema();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            if (schema.getClass(docType) != null) continue;
            ContentStore.createDocType(schema, docType);
        }
        if (schema.getClass("Signatures") == null) {
            OClass signatures = schema.createClass("Signatures");
            signatures.createProperty("key", OType.STRING).setNotNull(true);
            signatures.createProperty("sha1", OType.STRING).setNotNull(true);
        }
    }

    public void close() {
        this.db.close();
    }

    public void drop() {
        this.db.drop();
    }

    public long countClass(String iClassName) {
        return this.db.countClass(iClassName);
    }

    public List<ODocument> getDocumentStatus(String docType, String uri) {
        return this.query("select sha1,rendered from " + docType + " where sourceuri=?", uri);
    }

    public List<ODocument> getPublishedPosts() {
        return this.getPublishedContent("post");
    }

    public List<ODocument> getPublishedPostsByTag(String tag) {
        return this.query("select * from post where status='published' where ? in tags order by date desc", tag);
    }

    public List<ODocument> getPublishedPages() {
        return this.getPublishedContent("page");
    }

    public List<ODocument> getPublishedContent(String docType) {
        return this.query("select * from " + docType + " where status='published' order by date desc");
    }

    public List<ODocument> getAllContent(String docType) {
        return this.query("select * from " + docType + " order by date desc");
    }

    public List<ODocument> getAllTagsFromPublishedPosts() {
        return this.query("select tags from post where status='published'");
    }

    public List<ODocument> getSignaturesForTemplates() {
        return this.query("select sha1 from Signatures where key='templates'");
    }

    public List<ODocument> getUnrenderedContent(String docType) {
        return this.query("select * from " + docType + " where rendered=false");
    }

    public void deleteContent(String docType, String uri) {
        this.executeCommand("delete from " + docType + " where sourceuri=?", uri);
    }

    public void markConentAsRendered(String docType) {
        this.executeCommand("update " + docType + " set rendered=true where rendered=false and cached=true", new Object[0]);
    }

    public void updateSignatures(String currentTemplatesSignature) {
        this.executeCommand("update Signatures set sha1=? where key='templates'", currentTemplatesSignature);
    }

    public void deleteAllByDocType(String docType) {
        this.executeCommand("delete from " + docType, new Object[0]);
    }

    public void insertSignature(String currentTemplatesSignature) {
        this.executeCommand("insert into Signatures(key,sha1) values('templates',?)", currentTemplatesSignature);
    }

    private List<ODocument> query(String sql) {
        return this.db.query((OQuery)new OSQLSynchQuery(sql), new Object[0]);
    }

    private List<ODocument> query(String sql, Object ... args) {
        return (List)this.db.command((OCommandRequest)new OSQLSynchQuery(sql)).execute(args);
    }

    private void executeCommand(String query, Object ... args) {
        this.db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
    }

    private static void createDocType(OSchema schema, String doctype) {
        OClass page = schema.createClass(doctype);
        page.createProperty("sha1", OType.STRING).setNotNull(true);
        page.createProperty("sourceuri", OType.STRING).setNotNull(true);
        page.createProperty("rendered", OType.BOOLEAN).setNotNull(true);
        page.createProperty("cached", OType.BOOLEAN).setNotNull(true);
    }
}

