/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.lang.LocaleUtils;
import org.jbake.app.ContentStore;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.model.DocumentTypes;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.RenderingException;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateEngine
extends AbstractTemplateEngine {
    private final ReentrantLock lock = new ReentrantLock();
    private TemplateEngine templateEngine;
    private FileTemplateResolver templateResolver;

    public ThymeleafTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super(config, db, destination, templatesPath);
        this.initializeTemplateEngine();
    }

    private void initializeTemplateEngine() {
        this.templateResolver = new FileTemplateResolver();
        this.templateResolver.setPrefix(this.templatesPath.getAbsolutePath() + File.separatorChar);
        this.templateResolver.setCharacterEncoding(this.config.getString("template.encoding"));
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver);
        try {
            IDialect condCommentDialect = (IDialect)Class.forName("org.thymeleaf.extras.conditionalcomments.dialect.ConditionalCommentsDialect").newInstance();
            this.templateEngine.addDialect(condCommentDialect);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        String localeString = this.config.getString("thymeleaf.locale");
        Locale locale = localeString != null ? LocaleUtils.toLocale((String)localeString) : Locale.getDefault();
        Context context = new Context(locale, this.wrap(model));
        this.lock.lock();
        try {
            String key;
            String configMode;
            this.initializeTemplateEngine();
            Map config = (Map)model.get("config");
            Map content = (Map)model.get("content");
            String mode = "HTML5";
            if (config != null && content != null && (configMode = (String)config.get(key = "template_" + content.get("type") + "_thymeleaf_mode")) != null) {
                mode = configMode;
            }
            this.templateResolver.setTemplateMode(mode);
            this.templateEngine.process(templateName, (IContext)context, writer);
        }
        finally {
            this.lock.unlock();
        }
    }

    private VariablesMap<String, Object> wrap(Map<String, Object> model) {
        return new JBakeVariablesMap(model);
    }

    private class JBakeVariablesMap
    extends VariablesMap<String, Object> {
        public JBakeVariablesMap(Map<String, Object> model) {
            super(model);
            this.completeModel();
        }

        private void completeModel() {
            String[] documentTypes;
            this.put("db", ThymeleafTemplateEngine.this.db);
            this.put("alltags", this.getAllTags());
            this.put("tag_posts", this.getTagPosts());
            this.put("published_date", new Date());
            for (String docType : documentTypes = DocumentTypes.getDocumentTypes()) {
                this.put(docType + "s", DocumentList.wrap(ThymeleafTemplateEngine.this.db.getAllContent(docType).iterator()));
                this.put("published_" + docType + "s", DocumentList.wrap(ThymeleafTemplateEngine.this.db.getPublishedContent(docType).iterator()));
            }
            this.put("published_content", this.getPublishedContent());
            this.put("all_content", this.getAllContent());
        }

        private Object getTagPosts() {
            Object tagName = this.get("tag");
            if (tagName != null) {
                String tag = tagName.toString();
                List<ODocument> query = ThymeleafTemplateEngine.this.db.getPublishedPostsByTag(tag);
                return DocumentList.wrap(query.iterator());
            }
            return Collections.emptyList();
        }

        private Object getAllTags() {
            List<ODocument> query = ThymeleafTemplateEngine.this.db.getAllTagsFromPublishedPosts();
            HashSet result = new HashSet();
            for (ODocument document : query) {
                String[] tags = DBUtil.toStringArray(document.field("tags"));
                Collections.addAll(result, tags);
            }
            return result;
        }

        private Object getPublishedContent() {
            String[] documentTypes;
            ArrayList<ODocument> publishedContent = new ArrayList<ODocument>();
            for (String docType : documentTypes = DocumentTypes.getDocumentTypes()) {
                List<ODocument> query = ThymeleafTemplateEngine.this.db.getPublishedContent(docType);
                publishedContent.addAll(query);
            }
            return DocumentList.wrap(publishedContent.iterator());
        }

        private Object getAllContent() {
            String[] documentTypes;
            ArrayList<ODocument> allContent = new ArrayList<ODocument>();
            for (String docType : documentTypes = DocumentTypes.getDocumentTypes()) {
                List<ODocument> query = ThymeleafTemplateEngine.this.db.getAllContent(docType);
                allContent.addAll(query);
            }
            return DocumentList.wrap(allContent.iterator());
        }
    }
}

