/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.model.DocumentAttributes;
import org.jbake.model.DocumentTypes;

public class ContentStore {
    private ODatabaseDocumentTx db;
    private long start = -1L;
    private long limit = -1L;

    public ContentStore(String type, String name) {
        this.startupIfEnginesAreMissing();
        this.db = new ODatabaseDocumentTx(String.valueOf(type) + ":" + name);
        boolean exists = this.db.exists();
        if (!exists) {
            this.db.create();
        }
        this.db = (ODatabaseDocumentTx)ODatabaseDocumentPool.global().acquire(String.valueOf(type) + ":" + name, "admin", "admin");
        ODatabaseRecordThreadLocal.INSTANCE.set((ODatabaseRecord)this.db);
        if (!exists) {
            this.updateSchema();
        }
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void resetPagination() {
        this.start = -1L;
        this.limit = -1L;
    }

    public final void updateSchema() {
        OSchema schema = this.db.getMetadata().getSchema();
        String[] stringArray = DocumentTypes.getDocumentTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String docType = stringArray[n2];
            if (schema.getClass(docType) == null) {
                ContentStore.createDocType(schema, docType);
            }
            ++n2;
        }
        if (schema.getClass("Signatures") == null) {
            OClass signatures = schema.createClass("Signatures");
            signatures.createProperty("key", OType.STRING).setNotNull(true);
            signatures.createProperty("sha1", OType.STRING).setNotNull(true);
        }
    }

    public void close() {
        this.db.close();
        DBUtil.closeDataStore();
    }

    public void shutdown() {
        Orient.instance().shutdown();
    }

    private void startupIfEnginesAreMissing() {
        if (Orient.instance().getEngines().size() == 0) {
            Orient.instance().startup();
        }
    }

    public void drop() {
        this.db.drop();
    }

    public long getDocumentCount(String docType) {
        return this.db.countClass(docType);
    }

    public DocumentList getDocumentStatus(String docType, String uri) {
        return this.query("select sha1,rendered from " + docType + " where sourceuri=?", uri);
    }

    public DocumentList getPublishedPosts() {
        return this.getPublishedContent("post");
    }

    public DocumentList getPublishedPostsByTag(String tag) {
        return this.query("select * from post where status='published' and ? in tags order by date desc", tag);
    }

    public DocumentList getPublishedPages() {
        return this.getPublishedContent("page");
    }

    public DocumentList getPublishedContent(String docType) {
        String query = "select * from " + docType + " where status='published'";
        if (this.start >= 0L && this.limit > -1L) {
            query = String.valueOf(query) + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(String.valueOf(query) + " order by date desc");
    }

    public DocumentList getAllContent(String docType) {
        String query = "select * from " + docType;
        if (this.start >= 0L && this.limit > -1L) {
            query = String.valueOf(query) + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(String.valueOf(query) + " order by date desc");
    }

    public DocumentList getAllTagsFromPublishedPosts() {
        return this.query("select tags from post where status='published'");
    }

    public DocumentList getSignaturesForTemplates() {
        return this.query("select sha1 from Signatures where key='templates'");
    }

    public DocumentList getUnrenderedContent(String docType) {
        return this.query("select * from " + docType + " where rendered=false");
    }

    public void deleteContent(String docType, String uri) {
        this.executeCommand("delete from " + docType + " where sourceuri=?", uri);
    }

    public void markConentAsRendered(String docType) {
        this.executeCommand("update " + docType + " set rendered=true where rendered=false and cached=true", new Object[0]);
    }

    public void updateSignatures(String currentTemplatesSignature) {
        this.executeCommand("update Signatures set sha1=? where key='templates'", currentTemplatesSignature);
    }

    public void deleteAllByDocType(String docType) {
        this.executeCommand("delete from " + docType, new Object[0]);
    }

    public void insertSignature(String currentTemplatesSignature) {
        this.executeCommand("insert into Signatures(key,sha1) values('templates',?)", currentTemplatesSignature);
    }

    private DocumentList query(String sql) {
        List results = this.db.query((OQuery)new OSQLSynchQuery(sql), new Object[0]);
        return DocumentList.wrap(results.iterator());
    }

    private DocumentList query(String sql, Object ... args) {
        List results = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(sql)).execute(args);
        return DocumentList.wrap(results.iterator());
    }

    private void executeCommand(String query, Object ... args) {
        this.db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
    }

    public Set<String> getTags() {
        DocumentList docs = this.getAllTagsFromPublishedPosts();
        HashSet<String> result = new HashSet<String>();
        for (Map document : docs) {
            String[] tags = DBUtil.toStringArray(document.get("tags"));
            Collections.addAll(result, tags);
        }
        return result;
    }

    public Set<String> getAllTags() {
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = DocumentTypes.getDocumentTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String docType = stringArray[n2];
            DocumentList docs = this.query("select tags from " + docType + " where status='published'");
            for (Map document : docs) {
                String[] tags = DBUtil.toStringArray(document.get("tags"));
                Collections.addAll(result, tags);
            }
            ++n2;
        }
        return result;
    }

    private static void createDocType(OSchema schema, String doctype) {
        OClass page = schema.createClass(doctype);
        page.createProperty(String.valueOf((Object)DocumentAttributes.SHA1), OType.STRING).setNotNull(true);
        page.createProperty(String.valueOf((Object)DocumentAttributes.SOURCE_URI), OType.STRING).setNotNull(true);
        page.createProperty(String.valueOf((Object)DocumentAttributes.CACHED), OType.BOOLEAN).setNotNull(true);
        page.createProperty(String.valueOf((Object)DocumentAttributes.RENDERED), OType.BOOLEAN).setNotNull(true);
    }
}

