/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.jbake.app.Oven;
import org.jbake.launcher.LaunchOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFSChangeListener
implements FileListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomFSChangeListener.class);
    private LaunchOptions options;
    private CompositeConfiguration config;

    public CustomFSChangeListener(LaunchOptions res, CompositeConfiguration config) {
        this.options = res;
        this.config = config;
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        LOGGER.info("File created event detected: " + event.getFile().getURL());
        this.exec();
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        LOGGER.info("File deleted event detected: " + event.getFile().getURL());
        this.exec();
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        LOGGER.info("File changed event detected: " + event.getFile().getURL());
        this.exec();
    }

    private void exec() {
        Oven oven = new Oven(this.options.getSource(), this.options.getDestination(), this.config, this.options.isClearCache());
        oven.setupPaths();
        oven.bake();
    }
}

