/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.FileInputStream;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ZipUtil;

public class Init {
    private CompositeConfiguration config;

    public Init(CompositeConfiguration config) {
        this.config = config;
    }

    public void run(File outputFolder, File templateLocationFolder, String templateType) throws Exception {
        File templateFile;
        if (!outputFolder.canWrite()) {
            throw new Exception("Output folder is not writeable!");
        }
        File[] contents = outputFolder.listFiles();
        boolean safe = true;
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File content = fileArray[n2];
                if (content.isDirectory()) {
                    if (content.getName().equalsIgnoreCase(this.config.getString("template.folder"))) {
                        safe = false;
                    }
                    if (content.getName().equalsIgnoreCase(this.config.getString("content.folder"))) {
                        safe = false;
                    }
                    if (content.getName().equalsIgnoreCase(this.config.getString("asset.folder"))) {
                        safe = false;
                    }
                }
                ++n2;
            }
        }
        if (!safe) {
            throw new Exception(String.format("Output folder '%s' already contains structure!", outputFolder.getAbsolutePath()));
        }
        if (this.config.getString("example.project." + templateType) != null) {
            templateFile = new File(templateLocationFolder, this.config.getString("example.project." + templateType));
            if (!templateFile.exists()) {
                throw new Exception("Cannot find example project file: " + templateFile.getPath());
            }
        } else {
            throw new Exception("Cannot locate example project type: " + templateType);
        }
        ZipUtil.extract(new FileInputStream(templateFile), outputFolder);
    }
}

