/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.pegdown.PegDownProcessor;

public class MarkdownEngine
extends MarkupEngine {
    public MarkdownEngine() {
        Class<PegDownProcessor> engineClass = PegDownProcessor.class;
        assert (engineClass != null);
    }

    @Override
    public void processBody(ParserContext context) {
        String[] mdExts = context.getConfig().getStringArray("markdown.extensions");
        int extensions = 0;
        if (mdExts.length > 0) {
            int index = 0;
            while (index < mdExts.length) {
                String ext = mdExts[index];
                if (ext.startsWith("-")) {
                    ext = ext.substring(1);
                    extensions = this.removeExtension(extensions, this.extensionFor(ext));
                } else {
                    if (ext.startsWith("+")) {
                        ext = ext.substring(1);
                    }
                    extensions = this.addExtension(extensions, this.extensionFor(ext));
                }
                ++index;
            }
        }
        long maxParsingTime = context.getConfig().getLong("markdown.maxParsingTimeInMillis", 2000L);
        PegDownProcessor pegdownProcessor = new PegDownProcessor(extensions, maxParsingTime);
        context.setBody(pegdownProcessor.markdownToHtml(context.getBody()));
    }

    private int extensionFor(String name) {
        int extension = 0;
        if (name.equals("HARDWRAPS")) {
            extension = 8;
        } else if (name.equals("AUTOLINKS")) {
            extension = 16;
        } else if (name.equals("FENCED_CODE_BLOCKS")) {
            extension = 128;
        } else if (name.equals("DEFINITIONS")) {
            extension = 64;
        } else if (name.equals("ABBREVIATIONS")) {
            extension = 4;
        } else if (name.equals("QUOTES")) {
            extension = 2;
        } else if (name.equals("SMARTS")) {
            extension = 1;
        } else if (name.equals("SMARTYPANTS")) {
            extension = 3;
        } else if (name.equals("SUPPRESS_ALL_HTML")) {
            extension = 196608;
        } else if (name.equals("SUPPRESS_HTML_BLOCKS")) {
            extension = 65536;
        } else if (name.equals("SUPPRESS_INLINE_HTML")) {
            extension = 131072;
        } else if (name.equals("TABLES")) {
            extension = 32;
        } else if (name.equals("WIKILINKS")) {
            extension = 256;
        } else if (name.equals("ANCHORLINKS")) {
            extension = 1024;
        } else if (name.equals("STRIKETHROUGH")) {
            extension = 512;
        } else if (name.equals("ATXHEADERSPACE")) {
            extension = 262144;
        } else if (name.equals("FORCELISTITEMPARA")) {
            extension = 524288;
        } else if (name.equals("RELAXEDHRULES")) {
            extension = 0x100000;
        } else if (name.equals("TASKLISTITEMS")) {
            extension = 0x200000;
        } else if (name.equals("EXTANCHORLINKS")) {
            extension = 0x400000;
        } else if (name.equals("ALL")) {
            extension = 65535;
        } else if (name.equals("ALL_OPTIONALS")) {
            extension = 0x740000;
        } else if (name.equals("ALL_WITH_OPTIONALS")) {
            extension = 0x34FFFF;
        }
        return extension;
    }

    private int addExtension(int previousExtensions, int additionalExtension) {
        return previousExtensions | additionalExtension;
    }

    private int removeExtension(int previousExtensions, int unwantedExtension) {
        return previousExtensions & ~unwantedExtension;
    }
}

