/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.jbake.parser.ParserContext;
import org.jbake.parser.ParserEngine;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupEngine
implements ParserEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkupEngine.class);
    private static final String HEADER_SEPARATOR = "~~~~~~";

    public boolean validate(ParserContext context) {
        return true;
    }

    public void processHeader(ParserContext context) {
    }

    public void processBody(ParserContext context) {
    }

    @Override
    public Map<String, Object> parse(Configuration config, File file, String contentPath) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        FileInputStream is = null;
        List fileContents = null;
        try {
            try {
                is = new FileInputStream(file);
                fileContents = IOUtils.readLines((InputStream)is, (String)config.getString("render.encoding"));
            }
            catch (IOException e) {
                LOGGER.error("Error while opening file {}: {}", (Object)file, (Object)e);
                IOUtils.closeQuietly((InputStream)is);
                return null;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        boolean hasHeader = this.hasHeader(fileContents);
        ParserContext context = new ParserContext(file, fileContents, config, contentPath, hasHeader, content);
        if (hasHeader) {
            this.processHeader(config, fileContents, content);
        }
        this.processHeader(context);
        if (content.get("date") == null) {
            content.put("date", new Date(file.lastModified()));
        }
        if (config.getString("default.status") != null && content.get("status") == null) {
            content.put("status", config.getString("default.status"));
        }
        if (content.get("type") == null || content.get("status") == null) {
            LOGGER.warn("Error parsing meta data from header (missing type or status value) for file {}!", (Object)file);
            return null;
        }
        this.processBody(fileContents, content);
        if (!this.validate(context)) {
            LOGGER.error("Incomplete source file ({}) for markup engine:", (Object)file, (Object)this.getClass().getSimpleName());
            return null;
        }
        this.processBody(context);
        if (content.get("tags") != null) {
            String[] tags = (String[])content.get("tags");
            int i = 0;
            while (i < tags.length) {
                tags[i] = tags[i].trim();
                if (config.getBoolean("tag.sanitize")) {
                    tags[i] = tags[i].replace(" ", "-");
                }
                ++i;
            }
            content.put("tags", tags);
        }
        return content;
    }

    private boolean hasHeader(List<String> contents) {
        boolean headerValid = false;
        boolean headerSeparatorFound = false;
        boolean statusFound = false;
        boolean typeFound = false;
        ArrayList<String> header = new ArrayList<String>();
        for (String line : contents) {
            if (!line.isEmpty()) {
                header.add(line);
            }
            if (line.contains("=")) {
                if (line.startsWith("type=")) {
                    typeFound = true;
                }
                if (line.startsWith("status=")) {
                    statusFound = true;
                }
            }
            if (!line.equals(HEADER_SEPARATOR)) continue;
            headerSeparatorFound = true;
            header.remove(line);
            break;
        }
        if (headerSeparatorFound) {
            headerValid = true;
            for (String headerLine : header) {
                if (headerLine.contains("=")) continue;
                headerValid = false;
                break;
            }
        }
        return headerValid && statusFound && typeFound;
    }

    private void processHeader(Configuration config, List<String> contents, Map<String, Object> content) {
        for (String line : contents) {
            String[] parts;
            if (line.equals(HEADER_SEPARATOR)) break;
            if (line.isEmpty() || (parts = line.split("=", 2)).length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].trim();
            if (key.equalsIgnoreCase("date")) {
                SimpleDateFormat df = new SimpleDateFormat(config.getString("date.format"));
                Date date = null;
                try {
                    date = df.parse(value);
                    content.put(key, date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (key.equalsIgnoreCase("tags")) {
                content.put(key, this.getTags(value));
                continue;
            }
            if (this.isJson(value)) {
                content.put(key, JSONValue.parse((String)value));
                continue;
            }
            content.put(key, value);
        }
    }

    private String[] getTags(String tagsPart) {
        String[] tags = tagsPart.split(",");
        int i = 0;
        while (i < tags.length) {
            tags[i] = tags[i].trim();
            ++i;
        }
        return tags;
    }

    private boolean isJson(String part) {
        return part.startsWith("{") && part.endsWith("}");
    }

    private void processBody(List<String> contents, Map<String, Object> content) {
        StringBuilder body = new StringBuilder();
        boolean inBody = false;
        for (String line : contents) {
            if (inBody) {
                body.append(line).append("\n");
            }
            if (!line.equals(HEADER_SEPARATOR)) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : contents) {
                body.append(line).append("\n");
            }
        }
        content.put("body", body.toString());
    }
}

