/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.Asset;
import org.jbake.app.ConfigUtil;
import org.jbake.app.ContentStore;
import org.jbake.app.Crawler;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.app.FileUtil;
import org.jbake.app.JBakeException;
import org.jbake.app.Renderer;
import org.jbake.model.DocumentAttributes;
import org.jbake.model.DocumentTypes;
import org.jbake.render.RenderingTool;
import org.jbake.template.ModelExtractorsDocumentTypeListener;
import org.jbake.template.RenderingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oven {
    private static final Logger LOGGER = LoggerFactory.getLogger(Oven.class);
    private static final Pattern TEMPLATE_DOC_PATTERN = Pattern.compile("(?:template\\.)([a-zA-Z0-9-_]+)(?:\\.file)");
    private CompositeConfiguration config;
    private File source;
    private File destination;
    private File templatesPath;
    private File contentsPath;
    private File assetsPath;
    private boolean isClearCache;
    private List<Throwable> errors = new LinkedList<Throwable>();
    private int renderedCount = 0;

    public Oven(File source, File destination, boolean isClearCache) throws Exception {
        this(source, destination, ConfigUtil.load(source), isClearCache);
    }

    public Oven(File source, File destination, CompositeConfiguration config, boolean isClearCache) {
        this.source = source;
        this.destination = destination;
        this.config = config;
        this.isClearCache = isClearCache;
    }

    public CompositeConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CompositeConfiguration config) {
        this.config = config;
    }

    private void ensureSource() {
        if (!FileUtil.isExistingFolder(this.source)) {
            throw new JBakeException("Error: Source folder must exist: " + this.source.getAbsolutePath());
        }
        if (!this.source.canRead()) {
            throw new JBakeException("Error: Source folder is not readable: " + this.source.getAbsolutePath());
        }
    }

    private void ensureDestination() {
        if (this.destination == null) {
            this.destination = new File(this.source, this.config.getString("destination.folder"));
        }
        if (!this.destination.exists()) {
            this.destination.mkdirs();
        }
        if (!this.destination.canWrite()) {
            throw new JBakeException("Error: Destination folder is not writable: " + this.destination.getAbsolutePath());
        }
    }

    private File setupPathFromConfig(String key) {
        return new File(this.source, this.config.getString(key));
    }

    public void setupPaths() {
        this.ensureSource();
        this.templatesPath = this.setupRequiredFolderFromConfig("template.folder");
        this.contentsPath = this.setupRequiredFolderFromConfig("content.folder");
        this.assetsPath = this.setupPathFromConfig("asset.folder");
        if (!this.assetsPath.exists()) {
            LOGGER.warn("No asset folder was found!");
        }
        this.ensureDestination();
    }

    private File setupRequiredFolderFromConfig(String key) {
        File path = this.setupPathFromConfig(key);
        if (!FileUtil.isExistingFolder(path)) {
            throw new JBakeException("Error: Required folder cannot be found! Expected to find [" + key + "] at: " + path.getAbsolutePath());
        }
        return path;
    }

    public void bake() {
        ContentStore db = DBUtil.createDataStore(this.config.getString("db.store"), this.config.getString("db.path"));
        this.updateDocTypesFromConfiguration();
        DBUtil.updateSchema(db);
        try {
            long start = new Date().getTime();
            LOGGER.info("Baking has started...");
            this.clearCacheIfNeeded(db);
            Crawler crawler = new Crawler(db, this.source, this.config);
            crawler.crawl(this.contentsPath);
            LOGGER.info("Content detected:");
            String[] stringArray = DocumentTypes.getDocumentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docType = stringArray[n2];
                long count = db.getDocumentCount(docType);
                if (count > 0L) {
                    LOGGER.info("Parsed {} files of type: {}", (Object)count, (Object)docType);
                }
                ++n2;
            }
            Renderer renderer = new Renderer(db, this.destination, this.templatesPath, this.config);
            for (RenderingTool tool : ServiceLoader.load(RenderingTool.class)) {
                try {
                    this.renderedCount += tool.render(renderer, db, this.destination, this.templatesPath, this.config);
                }
                catch (RenderingException e) {
                    this.errors.add(e);
                }
            }
            String[] stringArray2 = DocumentTypes.getDocumentTypes();
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String docType = stringArray2[n4];
                db.markConentAsRendered(docType);
                ++n4;
            }
            Asset asset = new Asset(this.source, this.destination, this.config);
            asset.copy(this.assetsPath);
            this.errors.addAll(asset.getErrors());
            LOGGER.info("Baking finished!");
            long end = new Date().getTime();
            LOGGER.info("Baked {} items in {}ms", (Object)this.renderedCount, (Object)(end - start));
            if (this.errors.size() > 0) {
                LOGGER.error("Failed to bake {} item(s)!", (Object)this.errors.size());
            }
        }
        finally {
            db.close();
            db.shutdown();
        }
    }

    private void updateDocTypesFromConfiguration() {
        ModelExtractorsDocumentTypeListener listener = new ModelExtractorsDocumentTypeListener();
        DocumentTypes.addListener(listener);
        Iterator keyIterator = this.config.getKeys();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            Matcher matcher = TEMPLATE_DOC_PATTERN.matcher(key);
            if (!matcher.find()) continue;
            DocumentTypes.addDocumentType(matcher.group(1));
        }
    }

    private void clearCacheIfNeeded(ContentStore db) {
        boolean needed = this.isClearCache;
        if (!needed) {
            String currentTemplatesSignature;
            DocumentList docs = db.getSignaturesForTemplates();
            try {
                currentTemplatesSignature = FileUtil.sha1(this.templatesPath);
            }
            catch (Exception e) {
                currentTemplatesSignature = "";
            }
            if (!docs.isEmpty()) {
                String sha1 = (String)((Map)docs.get(0)).get(String.valueOf((Object)DocumentAttributes.SHA1));
                boolean bl = needed = !sha1.equals(currentTemplatesSignature);
                if (needed) {
                    db.updateSignatures(currentTemplatesSignature);
                }
            } else {
                db.insertSignature(currentTemplatesSignature);
                needed = true;
            }
        }
        if (needed) {
            String[] stringArray = DocumentTypes.getDocumentTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String docType = stringArray[n2];
                try {
                    db.deleteAllByDocType(docType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            DBUtil.updateSchema(db);
        }
    }

    public List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }
}

