/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.jbake.app.FileUtil;
import org.jbake.parser.Engines;
import org.jbake.parser.ParserEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger LOGGER = LoggerFactory.getLogger(Parser.class);
    private Configuration config;
    private String contentPath;

    public Parser(Configuration config, String contentPath) {
        this.config = config;
        this.contentPath = contentPath;
    }

    public Map<String, Object> processFile(File file) {
        ParserEngine engine = Engines.get(FileUtil.fileExt(file));
        if (engine == null) {
            LOGGER.error("Unable to find suitable markup engine for {}", (Object)file);
            return null;
        }
        return engine.parse(this.config, file, this.contentPath);
    }
}

