/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.template.DelegatingTemplateEngine;
import org.jbake.util.PagingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Renderer.class);
    private final File destination;
    private final CompositeConfiguration config;
    private final DelegatingTemplateEngine renderingEngine;
    private final ContentStore db;

    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config) {
        this.destination = destination;
        this.config = config;
        this.renderingEngine = new DelegatingTemplateEngine(config, db, destination, templatesPath);
        this.db = db;
    }

    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config, DelegatingTemplateEngine renderingEngine) {
        this.destination = destination;
        this.config = config;
        this.renderingEngine = renderingEngine;
        this.db = db;
    }

    private String findTemplateName(String docType) {
        String templateKey = "template." + docType + ".file";
        String returned = this.config.getString(templateKey);
        return returned;
    }

    public void render(Map<String, Object> content) throws Exception {
        File publishedFile;
        File draftFile;
        String docType = (String)content.get("type");
        String outputFilename = String.valueOf(this.destination.getPath()) + File.separatorChar + content.get("uri");
        if (outputFilename.lastIndexOf(".") > outputFilename.lastIndexOf(File.separatorChar)) {
            outputFilename = outputFilename.substring(0, outputFilename.lastIndexOf("."));
        }
        if ((draftFile = new File(String.valueOf(outputFilename) + this.config.getString("draft.suffix") + FileUtil.findExtension(this.config, docType))).exists()) {
            draftFile.delete();
        }
        if ((publishedFile = new File(String.valueOf(outputFilename) + FileUtil.findExtension(this.config, docType))).exists()) {
            publishedFile.delete();
        }
        if (content.get("status").equals("draft")) {
            outputFilename = String.valueOf(outputFilename) + this.config.getString("draft.suffix");
        }
        File outputFile = new File(String.valueOf(outputFilename) + FileUtil.findExtension(this.config, docType));
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering [").append(outputFile).append("]... ");
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", content);
        model.put("renderer", this.renderingEngine);
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(model, this.findTemplateName(docType), out);
            out.close();
            sb.append("done!");
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render file. Cause: " + e.getMessage(), e);
        }
    }

    private Writer createWriter(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.config.getString("render.encoding"));
    }

    private void render(RenderingConfig renderConfig) throws Exception {
        File outputFile = renderConfig.getPath();
        StringBuilder sb = new StringBuilder();
        sb.append("Rendering ").append(renderConfig.getName()).append(" [").append(outputFile).append("]...");
        try {
            Writer out = this.createWriter(outputFile);
            this.renderingEngine.renderDocument(renderConfig.getModel(), renderConfig.getTemplate(), out);
            out.close();
            sb.append("done!");
            LOGGER.info(sb.toString());
        }
        catch (Exception e) {
            sb.append("failed!");
            LOGGER.error(sb.toString(), (Throwable)e);
            throw new Exception("Failed to render " + renderConfig.getName(), e);
        }
    }

    public void renderIndex(String indexFile) throws Exception {
        this.render(new DefaultRenderingConfig(indexFile, "masterindex"));
    }

    public void renderIndexPaging(String indexFile) throws Exception {
        long totalPosts = this.db.getPublishedCount("post");
        int postsPerPage = this.config.getInt("index.posts_per_page", 5);
        if (totalPosts == 0L) {
            this.renderIndex(indexFile);
        } else {
            PagingHelper pagingHelper = new PagingHelper(totalPosts, postsPerPage);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("renderer", this.renderingEngine);
            model.put("content", this.buildSimpleModel("masterindex"));
            model.put("numberOfPages", pagingHelper.getNumberOfPages());
            this.db.setLimit(postsPerPage);
            try {
                int pageStart = 0;
                int page = 1;
                while ((long)pageStart < totalPosts) {
                    String fileName = indexFile;
                    this.db.setStart(pageStart);
                    model.put("currentPageNumber", page);
                    String previous = pagingHelper.getPreviousFileName(page, fileName);
                    model.put("previousFileName", previous);
                    String nextFileName = pagingHelper.getNextFileName(page, fileName);
                    model.put("nextFileName", nextFileName);
                    fileName = pagingHelper.getCurrentFileName(page, fileName);
                    ModelRenderingConfig renderConfig = new ModelRenderingConfig(fileName, model, "masterindex");
                    this.render(renderConfig);
                    pageStart += postsPerPage;
                    ++page;
                }
                this.db.resetPagination();
            }
            catch (Exception e) {
                throw new Exception("Failed to render index. Cause: " + e.getMessage(), e);
            }
        }
    }

    public void renderSitemap(String sitemapFile) throws Exception {
        this.render(new DefaultRenderingConfig(sitemapFile, "sitemap"));
    }

    public void renderFeed(String feedFile) throws Exception {
        this.render(new DefaultRenderingConfig(feedFile, "feed"));
    }

    public void renderArchive(String archiveFile) throws Exception {
        this.render(new DefaultRenderingConfig(archiveFile, "archive"));
    }

    public int renderTags(String tagPath) throws Exception {
        int renderedCount = 0;
        LinkedList<Exception> errors = new LinkedList<Exception>();
        for (String tag : this.db.getAllTags()) {
            try {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("renderer", this.renderingEngine);
                model.put("tag", tag);
                Map<String, Object> map = this.buildSimpleModel("tag");
                map.put("rootpath", "../");
                model.put("content", map);
                File path = new File(String.valueOf(this.destination.getPath()) + File.separator + tagPath + File.separator + tag + this.config.getString("output.extension"));
                this.render(new ModelRenderingConfig(path, "tag", model, this.findTemplateName("tag")));
                ++renderedCount;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render tags. Cause(s):");
            for (Throwable throwable : errors) {
                sb.append("\n").append(throwable.getMessage());
            }
            throw new Exception(sb.toString(), (Throwable)errors.get(0));
        }
        return renderedCount;
    }

    private Map<String, Object> buildSimpleModel(String type) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("type", type);
        content.put("rootpath", "");
        return content;
    }

    private static abstract class AbstractRenderingConfig
    implements RenderingConfig {
        protected final File path;
        protected final String name;
        protected final String template;

        public AbstractRenderingConfig(File path, String name, String template) {
            this.path = path;
            this.name = name;
            this.template = template;
        }

        @Override
        public File getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }
    }

    class DefaultRenderingConfig
    extends AbstractRenderingConfig {
        private final Object content;

        private DefaultRenderingConfig(File path, String allInOneName) {
            super(path, allInOneName, Renderer.this.findTemplateName(allInOneName));
            this.content = Renderer.this.buildSimpleModel(allInOneName);
        }

        public DefaultRenderingConfig(String filename, String allInOneName) {
            super(new File(String.valueOf(Renderer.this.destination.getPath()) + File.separator + filename), allInOneName, Renderer.this.findTemplateName(allInOneName));
            this.content = Renderer.this.buildSimpleModel(allInOneName);
        }

        public DefaultRenderingConfig(String allInOneName) {
            this(new File(String.valueOf(renderer.destination.getPath()) + File.separator + allInOneName + renderer.config.getString("output.extension")), allInOneName);
        }

        @Override
        public Map<String, Object> getModel() {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("renderer", Renderer.this.renderingEngine);
            model.put("content", this.content);
            if (Renderer.this.config.containsKey("index.paginate") && Renderer.this.config.getBoolean("index.paginate")) {
                model.put("numberOfPages", 0);
                model.put("currentPageNumber", 0);
                model.put("previousFileName", "");
                model.put("nextFileName", "");
            }
            return model;
        }
    }

    public class ModelRenderingConfig
    extends AbstractRenderingConfig {
        private final Map<String, Object> model;

        public ModelRenderingConfig(String fileName, Map<String, Object> model, String templateType) {
            super(new File(String.valueOf(Renderer.this.destination.getPath()) + File.separator + fileName), fileName, Renderer.this.findTemplateName(templateType));
            this.model = model;
        }

        public ModelRenderingConfig(File path, String name, Map<String, Object> model, String template) {
            super(path, name, template);
            this.model = model;
        }

        @Override
        public Map<String, Object> getModel() {
            return this.model;
        }
    }

    private static interface RenderingConfig {
        public File getPath();

        public String getName();

        public String getTemplate();

        public Map<String, Object> getModel();
    }
}

