/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.Renderer;
import org.jbake.model.DocumentTypes;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class DocumentsRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        int renderedCount = 0;
        LinkedList<String> errors = new LinkedList<String>();
        String[] stringArray = DocumentTypes.getDocumentTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String docType = stringArray[n2];
            DocumentList documentList = db.getUnrenderedContent(docType);
            for (Map page : documentList) {
                try {
                    renderer.render(page);
                    ++renderedCount;
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                }
            }
            ++n2;
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render documents. Cause(s):");
            for (String error : errors) {
                sb.append("\n").append(error);
            }
            throw new RenderingException(sb.toString());
        }
        return renderedCount;
    }
}

