/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import java.io.File;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.LocaleUtils;
import org.jbake.app.ContentStore;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateEngine
extends AbstractTemplateEngine {
    private final ReentrantLock lock = new ReentrantLock();
    private TemplateEngine templateEngine;
    private FileTemplateResolver templateResolver;
    private String templateMode;

    public ThymeleafTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((Configuration)config, db, destination, templatesPath);
    }

    private void initializeTemplateEngine(String mode) {
        if (mode.equals(this.templateMode)) {
            return;
        }
        this.templateMode = mode;
        this.templateResolver = new FileTemplateResolver();
        this.templateResolver.setPrefix(String.valueOf(this.templatesPath.getAbsolutePath()) + File.separatorChar);
        this.templateResolver.setCharacterEncoding(this.config.getString("template.encoding"));
        this.templateResolver.setTemplateMode(mode);
        this.templateEngine = new TemplateEngine();
        this.templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver);
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        String localeString = this.config.getString("thymeleaf.locale");
        Locale locale = localeString != null ? LocaleUtils.toLocale((String)localeString) : Locale.getDefault();
        Context context = new Context(locale, this.wrap(model));
        this.lock.lock();
        try {
            String key;
            String configMode;
            Map config = (Map)model.get("config");
            Map content = (Map)model.get("content");
            String mode = "HTML";
            if (config != null && content != null && (configMode = (String)config.get(key = "template_" + content.get("type") + "_thymeleaf_mode")) != null) {
                mode = configMode;
            }
            this.initializeTemplateEngine(mode);
            this.templateEngine.process(templateName, (IContext)context, writer);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Map<String, Object> wrap(Map<String, Object> model) {
        return new JBakeMap(model);
    }

    private class JBakeMap
    extends HashMap<String, Object> {
        public JBakeMap(Map<String, Object> model) {
            super(model);
            for (String key : extractors.keySet()) {
                try {
                    this.put(key, extractors.extractAndTransform(ThymeleafTemplateEngine.this.db, key, model, new TemplateEngineAdapter.NoopAdapter()));
                }
                catch (NoModelExtractorException noModelExtractorException) {
                    // empty catch block
                }
            }
        }
    }
}

