/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.util;

public class PagingHelper {
    long totalDocuments;
    int postsPerPage;

    public PagingHelper(long totalDocuments, int postsPerPage) {
        this.totalDocuments = totalDocuments;
        this.postsPerPage = postsPerPage;
    }

    public int getNumberOfPages() {
        return (int)Math.ceil((double)this.totalDocuments * 1.0 / ((double)this.postsPerPage * 1.0));
    }

    public String getNextFileName(int currentPageNumber, String fileName) {
        if (currentPageNumber < this.getNumberOfPages()) {
            int index = fileName.lastIndexOf(".");
            return String.valueOf(fileName.substring(0, index)) + (currentPageNumber + 1) + fileName.substring(index);
        }
        return null;
    }

    public String getPreviousFileName(int currentPageNumber, String fileName) {
        if (this.isFirstPage(currentPageNumber)) {
            return null;
        }
        int index = fileName.lastIndexOf(".");
        return String.valueOf(fileName.substring(0, index)) + (currentPageNumber > 2 ? Integer.valueOf(currentPageNumber - 1) : "") + fileName.substring(index);
    }

    private boolean isFirstPage(int page) {
        return page == 1;
    }

    public String getCurrentFileName(int page, String fileName) {
        int index = fileName.lastIndexOf(".");
        return String.valueOf(fileName.substring(0, index)) + (page > 1 ? Integer.valueOf(page) : "") + fileName.substring(index);
    }
}

