/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.jbake.app.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asset {
    private static final Logger LOGGER = LoggerFactory.getLogger(Asset.class);
    private final File source;
    private final File destination;
    private CompositeConfiguration config;
    private final List<Throwable> errors = new LinkedList<Throwable>();
    private final boolean ignoreHidden;

    public Asset(File source, File destination, CompositeConfiguration config) {
        this.source = source;
        this.destination = destination;
        this.config = config;
        this.ignoreHidden = config.getBoolean("asset.ignore", false);
    }

    public void copy(File path) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !(Asset.this.ignoreHidden && file.isHidden() || !file.isFile() && !FileUtil.directoryOnlyIfNotIgnored(file));
            }
        };
        this.copy(path, this.destination, filter);
    }

    private void copy(File sourceFolder, File targetFolder, FileFilter filter) {
        Object[] assets = sourceFolder.listFiles(filter);
        if (assets != null) {
            Arrays.sort(assets);
            for (Object asset : assets) {
                File target = new File(targetFolder, ((File)asset).getName());
                if (((File)asset).isFile()) {
                    try {
                        FileUtils.copyFile((File)asset, (File)target);
                        LOGGER.info("Copying [{}]... done!", (Object)((File)asset).getPath());
                    }
                    catch (IOException e) {
                        LOGGER.error("Copying [{}]... failed!", (Object)((File)asset).getPath(), (Object)e);
                        this.errors.add(e);
                    }
                    continue;
                }
                if (!((File)asset).isDirectory()) continue;
                this.copy((File)asset, target, filter);
            }
        }
    }

    public void copyAssetsFromContent(File path) {
        this.copy(path, this.destination, FileUtil.getNotContentFileFilter());
    }

    public List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }
}

