/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.model.DocumentAttributes;
import org.jbake.model.DocumentTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStore {
    private final Logger logger = LoggerFactory.getLogger(ContentStore.class);
    private ODatabaseDocumentTx db;
    private long start = -1L;
    private long limit = -1L;

    public ContentStore(String type, String name) {
        this.startupIfEnginesAreMissing();
        OPartitionedDatabasePool pool = new OPartitionedDatabasePoolFactory().get(type + ":" + name, "admin", "admin");
        pool.setAutoCreate(true);
        this.db = pool.acquire();
        ODatabaseRecordThreadLocal.instance().set((ODatabaseDocumentInternal)this.db);
        this.updateSchema();
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void resetPagination() {
        this.start = -1L;
        this.limit = -1L;
    }

    public final void updateSchema() {
        OSchemaProxy schema = this.db.getMetadata().getSchema();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            if (schema.existsClass(docType)) continue;
            this.createDocType((OSchema)schema, docType);
        }
        if (!schema.existsClass("Signatures")) {
            this.createSignatureType((OSchema)schema);
        }
    }

    public void close() {
        this.db.close();
        DBUtil.closeDataStore();
    }

    public void shutdown() {
        Orient.instance().shutdown();
    }

    private void startupIfEnginesAreMissing() {
        OLogManager.instance().setWarnEnabled(false);
        if (Orient.instance().getEngines().size() == 0) {
            Orient.instance().startup();
        }
        OLogManager.instance().setWarnEnabled(true);
    }

    public void drop() {
        this.db.drop();
    }

    public long getDocumentCount(String docType) {
        return this.db.countClass(docType);
    }

    public long getPublishedCount(String docType) {
        return (Long)((Map)this.query("select count(*) as count from " + docType + " where status='published'").get(0)).get("count");
    }

    public DocumentList getDocumentStatus(String docType, String uri) {
        return this.query("select sha1,rendered from " + docType + " where sourceuri=?", uri);
    }

    public DocumentList getPublishedPosts() {
        return this.getPublishedContent("post");
    }

    public DocumentList getPublishedPosts(boolean applyPaging) {
        return this.getPublishedContent("post", applyPaging);
    }

    public DocumentList getPublishedPostsByTag(String tag) {
        return this.query("select * from post where status='published' and ? in tags order by date desc", tag);
    }

    public DocumentList getPublishedDocumentsByTag(String tag) {
        DocumentList documents = new DocumentList();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            DocumentList documentsByTag = this.query("select * from " + docType + " where status='published' and ? in tags order by date desc", tag);
            documents.addAll(documentsByTag);
        }
        return documents;
    }

    public DocumentList getPublishedPages() {
        return this.getPublishedContent("page");
    }

    public DocumentList getPublishedContent(String docType) {
        return this.getPublishedContent(docType, false);
    }

    public DocumentList getPublishedContent(String docType, boolean applyPaging) {
        String query = "select * from " + docType + " where status='published' order by date desc";
        if (applyPaging && this.start >= 0L && this.limit > -1L) {
            query = query + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(query);
    }

    public DocumentList getAllContent(String docType) {
        return this.getAllContent(docType, false);
    }

    public DocumentList getAllContent(String docType, boolean applyPaging) {
        String query = "select * from " + docType + " order by date desc";
        if (applyPaging && this.start >= 0L && this.limit > -1L) {
            query = query + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(query);
    }

    public DocumentList getAllTagsFromPublishedPosts() {
        return this.query("select tags from post where status='published'");
    }

    public DocumentList getSignaturesForTemplates() {
        return this.query("select sha1 from Signatures where key='templates'");
    }

    public DocumentList getUnrenderedContent(String docType) {
        return this.query("select * from " + docType + " where rendered=false order by date desc");
    }

    public void deleteContent(String docType, String uri) {
        this.executeCommand("delete from " + docType + " where sourceuri=?", uri);
    }

    public void markContentAsRendered(String docType) {
        this.executeCommand("update " + docType + " set rendered=true where rendered=false and cached=true", new Object[0]);
    }

    public void updateSignatures(String currentTemplatesSignature) {
        this.executeCommand("update Signatures set sha1=? where key='templates'", currentTemplatesSignature);
    }

    public void deleteAllByDocType(String docType) {
        this.executeCommand("delete from " + docType, new Object[0]);
    }

    public void insertSignature(String currentTemplatesSignature) {
        this.executeCommand("insert into Signatures(key,sha1) values('templates',?)", currentTemplatesSignature);
    }

    private DocumentList query(String sql) {
        List results = this.db.query((OQuery)new OSQLSynchQuery(sql), new Object[0]);
        return DocumentList.wrap(results.iterator());
    }

    private DocumentList query(String sql, Object ... args) {
        List results = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(sql)).execute(args);
        return DocumentList.wrap(results.iterator());
    }

    private void executeCommand(String query, Object ... args) {
        this.db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
    }

    public Set<String> getTags() {
        DocumentList docs = this.getAllTagsFromPublishedPosts();
        HashSet<String> result = new HashSet<String>();
        for (Map document : docs) {
            String[] tags = DBUtil.toStringArray(document.get("tags"));
            Collections.addAll(result, tags);
        }
        return result;
    }

    public Set<String> getAllTags() {
        HashSet<String> result = new HashSet<String>();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            DocumentList docs = this.query("select tags from " + docType + " where status='published'");
            for (Map document : docs) {
                String[] tags = DBUtil.toStringArray(document.get("tags"));
                Collections.addAll(result, tags);
            }
        }
        return result;
    }

    private void createDocType(OSchema schema, String doctype) {
        this.logger.debug("Create document class '{}'", (Object)doctype);
        OClass page = schema.createClass(doctype);
        page.createProperty(String.valueOf((Object)DocumentAttributes.SHA1), OType.STRING).setNotNull(true);
        page.createIndex(doctype + "sha1Index", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{DocumentAttributes.SHA1.toString()});
        page.createProperty(String.valueOf((Object)DocumentAttributes.SOURCE_URI), OType.STRING).setNotNull(true);
        page.createIndex(doctype + "sourceUriIndex", OClass.INDEX_TYPE.UNIQUE, new String[]{DocumentAttributes.SOURCE_URI.toString()});
        page.createProperty(String.valueOf((Object)DocumentAttributes.CACHED), OType.BOOLEAN).setNotNull(true);
        page.createIndex(doctype + "cachedIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{DocumentAttributes.CACHED.toString()});
        page.createProperty(String.valueOf((Object)DocumentAttributes.RENDERED), OType.BOOLEAN).setNotNull(true);
        page.createIndex(doctype + "renderedIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{DocumentAttributes.RENDERED.toString()});
        page.createProperty(String.valueOf((Object)DocumentAttributes.STATUS), OType.STRING).setNotNull(true);
        page.createIndex(doctype + "statusIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{DocumentAttributes.STATUS.toString()});
    }

    private void createSignatureType(OSchema schema) {
        OClass signatures = schema.createClass("Signatures");
        signatures.createProperty(String.valueOf((Object)DocumentAttributes.SHA1), OType.STRING).setNotNull(true);
        signatures.createIndex("sha1Idx", OClass.INDEX_TYPE.UNIQUE, new String[]{DocumentAttributes.SHA1.toString()});
    }
}

