/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.jbake.launcher.CustomFSChangeListener;
import org.jbake.launcher.LaunchOptions;

public class BakeWatcher {
    public void start(LaunchOptions res, CompositeConfiguration config) {
        try {
            FileSystemManager fsMan = VFS.getManager();
            FileObject listenPath = fsMan.resolveFile(res.getSource(), config.getString("content.folder"));
            FileObject templateListenPath = fsMan.resolveFile(res.getSource(), config.getString("template.folder"));
            FileObject assetPath = fsMan.resolveFile(res.getSource(), config.getString("asset.folder"));
            System.out.println("Watching for (content, template, asset) changes in [" + res.getSource() + "]");
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new CustomFSChangeListener(res, config));
            monitor.setRecursive(true);
            monitor.addFile(listenPath);
            monitor.addFile(templateListenPath);
            monitor.addFile(assetPath);
            monitor.start();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
    }
}

