/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.JBakeException;
import org.jbake.app.Oven;
import org.jbake.launcher.LaunchOptions;

public class Baker {
    public void bake(LaunchOptions options, CompositeConfiguration config) {
        Oven oven = new Oven(options.getSource(), options.getDestination(), config, options.isClearCache());
        oven.setupPaths();
        oven.bake();
        List<Throwable> errors = oven.getErrors();
        if (!errors.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append(MessageFormat.format("JBake failed with {0} errors:\n", errors.size()));
            int errNr = 1;
            for (Throwable error : errors) {
                msg.append(MessageFormat.format("{0}. {1}\n", errNr, error.getMessage()));
                ++errNr;
            }
            throw new JBakeException(msg.toString(), errors.get(0));
        }
    }
}

