/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jbake.model.DocumentTypeListener;
import org.jbake.parser.Engines;

public class DocumentTypes {
    private static final Set<String> DEFAULT_DOC_TYPES = new LinkedHashSet<String>();
    private static final Set<DocumentTypeListener> LISTENERS = new HashSet<DocumentTypeListener>();

    public static void resetDocumentTypes() {
        DEFAULT_DOC_TYPES.clear();
        DEFAULT_DOC_TYPES.addAll(Arrays.asList("page", "post", "masterindex", "archive", "feed"));
    }

    public static void addDocumentType(String docType) {
        DEFAULT_DOC_TYPES.add(docType);
        DocumentTypes.notifyListener(docType);
    }

    private static void notifyListener(String docType) {
        for (DocumentTypeListener listener : LISTENERS) {
            listener.added(docType);
        }
    }

    public static void addListener(DocumentTypeListener listener) {
        LISTENERS.add(listener);
    }

    public static String[] getDocumentTypes() {
        Engines.getRecognizedExtensions();
        return DEFAULT_DOC_TYPES.toArray(new String[DEFAULT_DOC_TYPES.size()]);
    }

    public static boolean contains(String documentType) {
        return DEFAULT_DOC_TYPES.contains(documentType);
    }

    static {
        DocumentTypes.resetDocumentTypes();
    }
}

