/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import com.vladsch.flexmark.Extension;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profiles.pegdown.Extensions;
import com.vladsch.flexmark.profiles.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.options.DataHolder;
import java.lang.reflect.Field;
import org.jbake.parser.MarkupEngine;
import org.jbake.parser.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownEngine
extends MarkupEngine {
    private Logger logger = LoggerFactory.getLogger(MarkdownEngine.class);

    @Override
    public void processBody(ParserContext context) {
        String[] mdExts = context.getConfig().getStringArray("markdown.extensions");
        int extensions = 0;
        if (mdExts.length > 0) {
            for (int index = 0; index < mdExts.length; ++index) {
                String ext = mdExts[index];
                if (ext.startsWith("-")) {
                    ext = ext.substring(1);
                    extensions = this.removeExtension(extensions, this.extensionFor(ext));
                    continue;
                }
                if (ext.startsWith("+")) {
                    ext = ext.substring(1);
                }
                extensions = this.addExtension(extensions, this.extensionFor(ext));
            }
        }
        DataHolder options = PegdownOptionsAdapter.flexmarkOptions((int)extensions, (Extension[])new Extension[0]);
        Parser parser = Parser.builder((DataHolder)options).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
        Document document = parser.parse(context.getBody());
        context.setBody(renderer.render((Node)document));
    }

    private int extensionFor(String name) {
        int extension = 0;
        try {
            Field extField = Extensions.class.getDeclaredField(name);
            extension = extField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.debug("Undeclared extension field '{}', fallback to NONE", (Object)name);
        }
        return extension;
    }

    private int addExtension(int previousExtensions, int additionalExtension) {
        return previousExtensions | additionalExtension;
    }

    private int removeExtension(int previousExtensions, int unwantedExtension) {
        return previousExtensions & ~unwantedExtension;
    }
}

