/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.Renderer;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class IndexRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        if (config.getBoolean("render.index")) {
            try {
                if (this.shouldPaginateIndex(config)) {
                    renderer.renderIndexPaging(config.getString("index.file"));
                } else {
                    renderer.renderIndex(config.getString("index.file"));
                }
                return 1;
            }
            catch (Exception e) {
                throw new RenderingException(e);
            }
        }
        return 0;
    }

    private boolean shouldPaginateIndex(CompositeConfiguration config) {
        return config.containsKey("index.paginate") && config.getBoolean("index.paginate");
    }
}

