/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    private static final String LEGACY_CONFIG_FILE = "custom.properties";
    private static final String CONFIG_FILE = "jbake.properties";
    private static final String DEFAULT_CONFIG_FILE = "default.properties";
    private static boolean LEGACY_CONFIG_FILE_EXISTS = false;
    private static boolean LEGACY_CONFIG_FILE_WARNING_SHOWN = false;

    public static CompositeConfiguration load(File source) throws ConfigurationException {
        return ConfigUtil.load(source, false);
    }

    public static CompositeConfiguration load(File source, boolean isRunServer) throws ConfigurationException {
        CompositeConfiguration config = new CompositeConfiguration();
        config.setListDelimiter(',');
        File customConfigFile = new File(source, LEGACY_CONFIG_FILE);
        if (customConfigFile.exists()) {
            LEGACY_CONFIG_FILE_EXISTS = true;
            config.addConfiguration((Configuration)new PropertiesConfiguration(customConfigFile));
        }
        if ((customConfigFile = new File(source, CONFIG_FILE)).exists()) {
            config.addConfiguration((Configuration)new PropertiesConfiguration(customConfigFile));
        }
        config.addConfiguration((Configuration)new PropertiesConfiguration(DEFAULT_CONFIG_FILE));
        config.addConfiguration((Configuration)new SystemConfiguration());
        if (isRunServer) {
            String port = config.getString("server.port");
            config.setProperty("site.host", (Object)("http://localhost:" + port));
        }
        return config;
    }

    public static void displayLegacyConfigFileWarningIfRequired() {
        if (LEGACY_CONFIG_FILE_EXISTS && !LEGACY_CONFIG_FILE_WARNING_SHOWN) {
            LOGGER.warn("You have defined a part of your JBake configuration in custom.properties");
            LOGGER.warn("Usage of this file is being deprecated, please rename this file to: jbake.properties to remove this warning");
            LEGACY_CONFIG_FILE_WARNING_SHOWN = true;
        }
    }

    public static interface Keys {
        public static final String ARCHIVE_FILE = "archive.file";
        public static final String ASCIIDOCTOR_ATTRIBUTES = "asciidoctor.attributes";
        public static final String ASCIIDOCTOR_ATTRIBUTES_EXPORT = "asciidoctor.attributes.export";
        public static final String ASCIIDOCTOR_ATTRIBUTES_EXPORT_PREFIX = "asciidoctor.attributes.export.prefix";
        public static final String ASCIIDOCTOR_OPTION = "asciidoctor.option";
        public static final String ASSET_FOLDER = "asset.folder";
        public static final String URI_NO_EXTENSION = "uri.noExtension";
        public static final String URI_NO_EXTENSION_PREFIX = "uri.noExtension.prefix";
        public static final String ASSET_IGNORE_HIDDEN = "asset.ignore";
        public static final String BUILD_TIMESTAMP = "build.timestamp";
        public static final String CONTENT_FOLDER = "content.folder";
        public static final String DATE_FORMAT = "date.format";
        public static final String DB_PATH = "db.path";
        public static final String DB_STORE = "db.store";
        public static final String DEFAULT_STATUS = "default.status";
        public static final String DEFAULT_TYPE = "default.type";
        public static final String DESTINATION_FOLDER = "destination.folder";
        public static final String DRAFT_SUFFIX = "draft.suffix";
        public static final String FEED_FILE = "feed.file";
        public static final String INDEX_FILE = "index.file";
        public static final String OUTPUT_EXTENSION = "output.extension";
        public static final String RENDER_ARCHIVE = "render.archive";
        public static final String RENDER_ENCODING = "render.encoding";
        public static final String RENDER_FEED = "render.feed";
        public static final String RENDER_INDEX = "render.index";
        public static final String RENDER_SITEMAP = "render.sitemap";
        public static final String RENDER_TAGS = "render.tags";
        public static final String RENDER_TAGS_INDEX = "render.tagsindex";
        public static final String HEADER_SEPARATOR = "header.separator";
        public static final String SERVER_PORT = "server.port";
        public static final String SITEMAP_FILE = "sitemap.file";
        public static final String TAG_PATH = "tag.path";
        public static final String TAG_SANITIZE = "tag.sanitize";
        public static final String TEMPLATE_ENCODING = "template.encoding";
        public static final String TEMPLATE_FOLDER = "template.folder";
        public static final String THYMELEAF_LOCALE = "thymeleaf.locale";
        public static final String VERSION = "version";
        public static final String PAGINATE_INDEX = "index.paginate";
        public static final String POSTS_PER_PAGE = "index.posts_per_page";
        public static final String SITE_HOST = "site.host";
    }
}

