/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FilenameUtils;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.FileUtil;
import org.jbake.app.Parser;
import org.jbake.model.DocumentAttributes;
import org.jbake.model.DocumentStatus;
import org.jbake.model.DocumentTypes;
import org.jbake.util.HtmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    private CompositeConfiguration config;
    private Parser parser;
    private final ContentStore db;
    private String contentPath;

    public Crawler(ContentStore db, File source, CompositeConfiguration config) {
        this.db = db;
        this.config = config;
        this.contentPath = FilenameUtils.concat((String)source.getAbsolutePath(), (String)config.getString("content.folder"));
        this.parser = new Parser((Configuration)config, this.contentPath);
    }

    public void crawl(File path) {
        Object[] contents = path.listFiles(FileUtil.getFileFilter());
        if (contents != null) {
            Arrays.sort(contents);
            for (Object sourceFile : contents) {
                if (((File)sourceFile).isFile()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Processing [").append(((File)sourceFile).getPath()).append("]... ");
                    String sha1 = this.buildHash((File)sourceFile);
                    String uri = this.buildURI((File)sourceFile);
                    boolean process = true;
                    DocumentStatus status = DocumentStatus.NEW;
                    for (String docType : DocumentTypes.getDocumentTypes()) {
                        status = this.findDocumentStatus(docType, uri, sha1);
                        switch (status) {
                            case UPDATED: {
                                sb.append(" : modified ");
                                this.db.deleteContent(docType, uri);
                                break;
                            }
                            case IDENTICAL: {
                                sb.append(" : same ");
                                process = false;
                            }
                        }
                        if (!process) break;
                    }
                    if (DocumentStatus.NEW == status) {
                        sb.append(" : new ");
                    }
                    if (process) {
                        this.crawlSourceFile((File)sourceFile, sha1, uri);
                    }
                    LOGGER.info("{}", (Object)sb);
                }
                if (!((File)sourceFile).isDirectory()) continue;
                this.crawl((File)sourceFile);
            }
        }
    }

    private String buildHash(File sourceFile) {
        String sha1;
        try {
            sha1 = FileUtil.sha1(sourceFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            sha1 = "";
        }
        return sha1;
    }

    private String buildURI(File sourceFile) {
        String uri = FileUtil.asPath(sourceFile.getPath()).replace(FileUtil.asPath(this.contentPath), "").replace(File.separator, "/");
        uri = this.useNoExtensionUri(uri) ? this.createNoExtensionUri(uri) : this.createUri(uri);
        if (uri.startsWith("/")) {
            uri = uri.substring(1, uri.length());
        }
        return uri;
    }

    private String createUri(String uri) {
        return uri.substring(0, uri.lastIndexOf(46)) + this.config.getString("output.extension");
    }

    private String createNoExtensionUri(String uri) {
        return "/" + FilenameUtils.getPath((String)uri) + FilenameUtils.getBaseName((String)uri) + "/index" + this.config.getString("output.extension");
    }

    private boolean useNoExtensionUri(String uri) {
        boolean noExtensionUri = this.config.getBoolean("uri.noExtension");
        String noExtensionUriPrefix = this.config.getString("uri.noExtension.prefix");
        return noExtensionUri && noExtensionUriPrefix != null && noExtensionUriPrefix.length() > 0 && uri.startsWith(noExtensionUriPrefix);
    }

    private void crawlSourceFile(File sourceFile, String sha1, String uri) {
        Map<String, Object> fileContents = this.parser.processFile(sourceFile);
        if (fileContents != null) {
            fileContents.put("rootpath", this.getPathToRoot(sourceFile));
            fileContents.put(String.valueOf((Object)DocumentAttributes.SHA1), sha1);
            fileContents.put(String.valueOf((Object)DocumentAttributes.RENDERED), false);
            if (fileContents.get("tags") != null) {
                String[] tags = (String[])fileContents.get("tags");
                fileContents.put("tags", tags);
            }
            fileContents.put("file", sourceFile.getPath());
            fileContents.put(String.valueOf((Object)DocumentAttributes.SOURCE_URI), uri);
            fileContents.put("uri", uri);
            String documentType = (String)fileContents.get("type");
            if (fileContents.get("status").equals("published-date") && fileContents.get("date") != null && fileContents.get("date") instanceof Date && new Date().after((Date)fileContents.get("date"))) {
                fileContents.put("status", "published");
            }
            if (this.config.getBoolean("uri.noExtension")) {
                fileContents.put("noExtensionUri", uri.replace("/index.html", "/"));
            }
            HtmlUtil.fixImageSourceUrls(fileContents, this.config);
            ODocument doc = new ODocument(documentType);
            doc.fromMap(fileContents);
            boolean cached = fileContents.get(String.valueOf((Object)DocumentAttributes.CACHED)) != null ? Boolean.valueOf((String)fileContents.get(String.valueOf((Object)DocumentAttributes.CACHED))) : true;
            doc.field(String.valueOf((Object)DocumentAttributes.CACHED), (Object)cached);
            doc.save();
        } else {
            LOGGER.warn("{} has an invalid header, it has been ignored!", (Object)sourceFile);
        }
    }

    public String getPathToRoot(File sourceFile) {
        File rootPath = new File(this.contentPath);
        File parentPath = sourceFile.getParentFile();
        int parentCount = 0;
        while (!parentPath.equals(rootPath)) {
            parentPath = parentPath.getParentFile();
            ++parentCount;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parentCount; ++i) {
            sb.append("../");
        }
        if (this.config.getBoolean("uri.noExtension")) {
            sb.append("../");
        }
        return sb.toString();
    }

    private DocumentStatus findDocumentStatus(String docType, String uri, String sha1) {
        DocumentList match = this.db.getDocumentStatus(docType, uri);
        if (!match.isEmpty()) {
            Map entries = (Map)match.get(0);
            String oldHash = (String)entries.get(String.valueOf((Object)DocumentAttributes.SHA1));
            if (!oldHash.equals(sha1) || Boolean.FALSE.equals(entries.get(String.valueOf((Object)DocumentAttributes.RENDERED)))) {
                return DocumentStatus.UPDATED;
            }
            return DocumentStatus.IDENTICAL;
        }
        return DocumentStatus.NEW;
    }

    public static interface Attributes {
        public static final String DATE = "date";
        public static final String STATUS = "status";
        public static final String TYPE = "type";
        public static final String TITLE = "title";
        public static final String URI = "uri";
        public static final String FILE = "file";
        public static final String TAGS = "tags";
        public static final String TAG = "tag";
        public static final String ROOTPATH = "rootpath";
        public static final String ID = "id";
        public static final String NO_EXTENSION_URI = "noExtensionUri";
        public static final String ALLTAGS = "alltags";
        public static final String PUBLISHED_DATE = "published_date";
        public static final String BODY = "body";
        public static final String DB = "db";

        public static interface Status {
            public static final String PUBLISHED_DATE = "published-date";
            public static final String PUBLISHED = "published";
            public static final String DRAFT = "draft";
        }
    }
}

