/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.FileUtil;
import org.jbake.template.DelegatingTemplateEngine;
import org.jbake.util.PagingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Renderer {
    private static final String MASTERINDEX_TEMPLATE_NAME = "masterindex";
    private static final String SITEMAP_TEMPLATE_NAME = "sitemap";
    private static final String FEED_TEMPLATE_NAME = "feed";
    private static final String ARCHIVE_TEMPLATE_NAME = "archive";
    private static final Logger LOGGER = LoggerFactory.getLogger(Renderer.class);
    private final File destination;
    private final CompositeConfiguration config;
    private final DelegatingTemplateEngine renderingEngine;
    private final ContentStore db;

    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config) {
        this.destination = destination;
        this.config = config;
        this.renderingEngine = new DelegatingTemplateEngine(config, db, destination, templatesPath);
        this.db = db;
    }

    public Renderer(ContentStore db, File destination, File templatesPath, CompositeConfiguration config, DelegatingTemplateEngine renderingEngine) {
        this.destination = destination;
        this.config = config;
        this.renderingEngine = renderingEngine;
        this.db = db;
    }

    private String findTemplateName(String docType) {
        String templateKey = "template." + docType + ".file";
        String returned = this.config.getString(templateKey);
        return returned;
    }

    public void render(Map<String, Object> content) throws Exception {
        File publishedFile;
        File draftFile;
        String docType = (String)content.get("type");
        String outputFilename = this.destination.getPath() + File.separatorChar + ((String)content.get("uri")).replace("/", File.separator);
        if (outputFilename.lastIndexOf(46) > outputFilename.lastIndexOf(File.separatorChar)) {
            outputFilename = outputFilename.substring(0, outputFilename.lastIndexOf(46));
        }
        if ((draftFile = new File(outputFilename + this.config.getString("draft.suffix") + FileUtil.findExtension(this.config, docType))).exists()) {
            draftFile.delete();
        }
        if ((publishedFile = new File(outputFilename + FileUtil.findExtension(this.config, docType))).exists()) {
            publishedFile.delete();
        }
        if (content.get("status").equals("draft")) {
            outputFilename = outputFilename + this.config.getString("draft.suffix");
        }
        File outputFile = new File(outputFilename + FileUtil.findExtension(this.config, docType));
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("content", content);
        model.put("renderer", this.renderingEngine);
        try {
            try (Writer out = this.createWriter(outputFile);){
                this.renderingEngine.renderDocument(model, this.findTemplateName(docType), out);
            }
            LOGGER.info("Rendering [{}]... done!", (Object)outputFile);
        }
        catch (Exception e) {
            LOGGER.error("Rendering [{}]... failed!", (Object)outputFile, (Object)e);
            throw new Exception("Failed to render file " + outputFile.getAbsolutePath() + ". Cause: " + e.getMessage(), e);
        }
    }

    private Writer createWriter(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.config.getString("render.encoding"));
    }

    private void render(RenderingConfig renderConfig) throws Exception {
        File outputFile = renderConfig.getPath();
        try {
            try (Writer out = this.createWriter(outputFile);){
                this.renderingEngine.renderDocument(renderConfig.getModel(), renderConfig.getTemplate(), out);
            }
            LOGGER.info("Rendering {} [{}]... done!", (Object)renderConfig.getName(), (Object)outputFile);
        }
        catch (Exception e) {
            LOGGER.error("Rendering {} [{}]... failed!", new Object[]{renderConfig.getName(), outputFile, e});
            throw new Exception("Failed to render " + renderConfig.getName(), e);
        }
    }

    public void renderIndex(String indexFile) throws Exception {
        this.render(new DefaultRenderingConfig(indexFile, MASTERINDEX_TEMPLATE_NAME));
    }

    public void renderIndexPaging(String indexFile) throws Exception {
        long totalPosts = this.db.getPublishedCount("post");
        int postsPerPage = this.config.getInt("index.posts_per_page", 5);
        if (totalPosts == 0L) {
            this.renderIndex(indexFile);
        } else {
            PagingHelper pagingHelper = new PagingHelper(totalPosts, postsPerPage);
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("renderer", this.renderingEngine);
            model.put("numberOfPages", pagingHelper.getNumberOfPages());
            try {
                this.db.setLimit(postsPerPage);
                int pageStart = 0;
                int page = 1;
                while ((long)pageStart < totalPosts) {
                    String fileName = indexFile;
                    this.db.setStart(pageStart);
                    model.put("currentPageNumber", page);
                    String previous = pagingHelper.getPreviousFileName(page);
                    model.put("previousFileName", previous);
                    String nextFileName = pagingHelper.getNextFileName(page);
                    model.put("nextFileName", nextFileName);
                    Map<String, Object> contentModel = this.buildSimpleModel(MASTERINDEX_TEMPLATE_NAME);
                    if (page > 1) {
                        contentModel.put("rootpath", "../");
                    }
                    model.put("content", contentModel);
                    fileName = pagingHelper.getCurrentFileName(page, fileName);
                    ModelRenderingConfig renderConfig = new ModelRenderingConfig(fileName, model, MASTERINDEX_TEMPLATE_NAME);
                    this.render(renderConfig);
                    pageStart += postsPerPage;
                    ++page;
                }
                this.db.resetPagination();
            }
            catch (Exception e) {
                throw new Exception("Failed to render index. Cause: " + e.getMessage(), e);
            }
        }
    }

    public void renderSitemap(String sitemapFile) throws Exception {
        this.render(new DefaultRenderingConfig(sitemapFile, SITEMAP_TEMPLATE_NAME));
    }

    public void renderFeed(String feedFile) throws Exception {
        this.render(new DefaultRenderingConfig(feedFile, FEED_TEMPLATE_NAME));
    }

    public void renderArchive(String archiveFile) throws Exception {
        this.render(new DefaultRenderingConfig(archiveFile, ARCHIVE_TEMPLATE_NAME));
    }

    public int renderTags(String tagPath) throws Exception {
        int renderedCount = 0;
        LinkedList<Exception> errors = new LinkedList<Exception>();
        for (String tag : this.db.getAllTags()) {
            try {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("renderer", this.renderingEngine);
                hashMap.put("tag", tag);
                Map<String, Object> map = this.buildSimpleModel("tag");
                map.put("rootpath", "../");
                hashMap.put("content", map);
                File path = new File(this.destination.getPath() + File.separator + tagPath + File.separator + tag + this.config.getString("output.extension"));
                this.render(new ModelRenderingConfig(path, "tag", hashMap, this.findTemplateName("tag")));
                ++renderedCount;
            }
            catch (Exception exception) {
                errors.add(exception);
            }
        }
        if (this.config.getBoolean("render.tagsindex")) {
            try {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("renderer", this.renderingEngine);
                Map<String, Object> map = this.buildSimpleModel("tags");
                map.put("rootpath", "../");
                model.put("content", map);
                File file = new File(this.destination.getPath() + File.separator + tagPath + File.separator + "index" + this.config.getString("output.extension"));
                this.render(new ModelRenderingConfig(file, "tagindex", model, this.findTemplateName("tagsindex")));
                ++renderedCount;
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render tags. Cause(s):");
            for (Throwable throwable : errors) {
                sb.append("\n").append(throwable.getMessage());
            }
            throw new Exception(sb.toString(), (Throwable)errors.get(0));
        }
        return renderedCount;
    }

    private Map<String, Object> buildSimpleModel(String type) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("type", type);
        content.put("rootpath", "");
        return content;
    }

    class DefaultRenderingConfig
    extends AbstractRenderingConfig {
        private final Object content;

        private DefaultRenderingConfig(File path, String allInOneName) {
            super(path, allInOneName, Renderer.this.findTemplateName(allInOneName));
            this.content = Renderer.this.buildSimpleModel(allInOneName);
        }

        public DefaultRenderingConfig(String filename, String allInOneName) {
            super(new File(Renderer.this.destination.getPath() + File.separator + filename), allInOneName, Renderer.this.findTemplateName(allInOneName));
            this.content = Renderer.this.buildSimpleModel(allInOneName);
        }

        public DefaultRenderingConfig(String allInOneName) {
            this(new File(this$0.destination.getPath() + File.separator + allInOneName + this$0.config.getString("output.extension")), allInOneName);
        }

        @Override
        public Map<String, Object> getModel() {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("renderer", Renderer.this.renderingEngine);
            model.put("content", this.content);
            if (Renderer.this.config.containsKey("index.paginate") && Renderer.this.config.getBoolean("index.paginate")) {
                model.put("numberOfPages", 0);
                model.put("currentPageNumber", 0);
                model.put("previousFileName", "");
                model.put("nextFileName", "");
            }
            return model;
        }
    }

    public class ModelRenderingConfig
    extends AbstractRenderingConfig {
        private final Map<String, Object> model;

        public ModelRenderingConfig(String fileName, Map<String, Object> model, String templateType) {
            super(new File(Renderer.this.destination.getPath() + File.separator + fileName), fileName, Renderer.this.findTemplateName(templateType));
            this.model = model;
        }

        public ModelRenderingConfig(File path, String name, Map<String, Object> model, String template) {
            super(path, name, template);
            this.model = model;
        }

        @Override
        public Map<String, Object> getModel() {
            return this.model;
        }
    }

    private static abstract class AbstractRenderingConfig
    implements RenderingConfig {
        protected final File path;
        protected final String name;
        protected final String template;

        public AbstractRenderingConfig(File path, String name, String template) {
            this.path = path;
            this.name = name;
            this.template = template;
        }

        @Override
        public File getPath() {
            return this.path;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getTemplate() {
            return this.template;
        }
    }

    private static interface RenderingConfig {
        public File getPath();

        public String getName();

        public String getTemplate();

        public Map<String, Object> getModel();
    }
}

