/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.launcher;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.jbake.app.ConfigUtil;
import org.jbake.app.FileUtil;
import org.jbake.app.JBakeException;
import org.jbake.launcher.BakeWatcher;
import org.jbake.launcher.Baker;
import org.jbake.launcher.Init;
import org.jbake.launcher.JettyServer;
import org.jbake.launcher.LaunchOptions;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main {
    private final String USAGE_PREFIX = "Usage: jbake";
    private final String ALT_USAGE_PREFIX = "   or  jbake";
    private Baker baker;
    private JettyServer jettyServer;
    private BakeWatcher watcher;

    public static void main(String[] args) {
        try {
            new Main().run(args);
        }
        catch (JBakeException e) {
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println("An unexpected error occurred: " + e.getMessage());
            System.exit(2);
        }
    }

    public Main() {
        this(new Baker(), new JettyServer(), new BakeWatcher());
    }

    protected Main(Baker baker, JettyServer jetty, BakeWatcher watcher) {
        this.baker = baker;
        this.jettyServer = jetty;
        this.watcher = watcher;
    }

    protected void run(String[] args) {
        CompositeConfiguration config;
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        LaunchOptions res = this.parseArguments(args);
        try {
            config = ConfigUtil.load(res.getSource(), res.isRunServer());
        }
        catch (ConfigurationException e) {
            throw new JBakeException("Configuration error: " + e.getMessage(), e);
        }
        this.run(res, config);
    }

    protected void run(LaunchOptions res, CompositeConfiguration config) {
        System.out.println("JBake " + config.getString("version") + " (" + config.getString("build.timestamp") + ") [http://jbake.org]");
        System.out.println();
        if (res.isHelpNeeded()) {
            this.printUsage(res);
            return;
        }
        if (res.isBake()) {
            ConfigUtil.displayLegacyConfigFileWarningIfRequired();
            this.baker.bake(res, config);
        }
        if (res.isInit()) {
            this.initStructure(config, res.getTemplate(), res.getSourceValue());
        }
        if (res.isRunServer()) {
            ConfigUtil.displayLegacyConfigFileWarningIfRequired();
            this.watcher.start(res, config);
            if (res.isBake()) {
                if (res.getDestination() != null) {
                    this.runServer(res.getDestination().getPath(), config.getString("server.port"));
                } else if (!res.getSource().getPath().equals(".")) {
                    this.runServer(res.getSource().getPath(), config.getString("server.port"));
                } else {
                    this.runServer(config.getString("destination.folder"), config.getString("server.port"));
                }
            } else if (!res.getSource().getPath().equals(".")) {
                this.runServer(res.getSource().getPath(), config.getString("server.port"));
            } else {
                this.runServer(config.getString("destination.folder"), config.getString("server.port"));
            }
        }
    }

    private LaunchOptions parseArguments(String[] args) {
        LaunchOptions res = new LaunchOptions();
        CmdLineParser parser = new CmdLineParser((Object)res);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.printUsage(res);
            throw new JBakeException("Invalid commandline arguments: " + e.getMessage(), e);
        }
        return res;
    }

    private void printUsage(Object options) {
        CmdLineParser parser = new CmdLineParser(options);
        StringWriter sw = new StringWriter();
        sw.append("Usage: jbake\n");
        sw.append("   or  jbake <source> <destination>\n");
        sw.append("   or  jbake [OPTION]... [<value>...]\n\n");
        sw.append("Options:");
        System.out.println(sw.toString());
        parser.getProperties().withUsageWidth(100);
        parser.printUsage((OutputStream)System.out);
    }

    private void runServer(String path, String port) {
        this.jettyServer.run(path, port);
    }

    private void initStructure(CompositeConfiguration config, String type, String source) {
        Init init = new Init(config);
        try {
            File templateFolder = FileUtil.getRunningLocation();
            File outputFolder = source != null ? new File(source) : new File(".");
            init.run(outputFolder, templateFolder, type);
            System.out.println("Base folder structure successfully created.");
        }
        catch (Exception e) {
            String msg = "Failed to initialise structure: " + e.getMessage();
            throw new JBakeException(msg, e);
        }
    }
}

