/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.IOUtils;
import org.jbake.parser.ParserContext;
import org.jbake.parser.ParserEngine;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MarkupEngine
implements ParserEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkupEngine.class);

    public boolean validate(ParserContext context) {
        return true;
    }

    public void processHeader(ParserContext context) {
    }

    public void processBody(ParserContext context) {
    }

    @Override
    public Map<String, Object> parse(Configuration config, File file, String contentPath) {
        HashMap<String, Object> content = new HashMap<String, Object>();
        List fileContents = null;
        try (FileInputStream is = new FileInputStream(file);){
            fileContents = IOUtils.readLines((InputStream)is, (String)config.getString("render.encoding"));
        }
        catch (IOException e) {
            LOGGER.error("Error while opening file {}", (Object)file, (Object)e);
            return null;
        }
        boolean hasHeader = this.hasHeader(config, fileContents);
        ParserContext context = new ParserContext(file, fileContents, config, contentPath, hasHeader, content);
        if (hasHeader) {
            this.processHeader(config, fileContents, content);
        }
        this.processHeader(context);
        if (content.get("date") == null) {
            content.put("date", new Date(file.lastModified()));
        }
        if (config.getString("default.status") != null && content.get("status") == null) {
            content.put("status", config.getString("default.status"));
        }
        if (config.getString("default.type") != null && content.get("type") == null) {
            content.put("type", config.getString("default.type"));
        }
        if (content.get("type") == null || content.get("status") == null) {
            LOGGER.warn("Parsing skipped (missing type or status value in header meta data) for file {}!", (Object)file);
            return null;
        }
        this.processBody(config, fileContents, content);
        if (!this.validate(context)) {
            LOGGER.error("Incomplete source file ({}) for markup engine: {}", (Object)file, (Object)this.getClass().getSimpleName());
            return null;
        }
        this.processBody(context);
        if (content.get("tags") != null) {
            String[] tags = (String[])content.get("tags");
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = tags[i].trim();
                if (!config.getBoolean("tag.sanitize")) continue;
                tags[i] = tags[i].replace(" ", "-");
            }
            content.put("tags", tags);
        }
        return content;
    }

    private boolean hasHeader(Configuration config, List<String> contents) {
        boolean headerValid = false;
        boolean headerSeparatorFound = false;
        boolean statusFound = false;
        boolean typeFound = false;
        ArrayList<String> header = new ArrayList<String>();
        for (String line : contents) {
            if (!line.isEmpty()) {
                header.add(line);
            }
            if (line.contains("=")) {
                if (line.startsWith("type=")) {
                    typeFound = true;
                }
                if (line.startsWith("status=")) {
                    statusFound = true;
                }
            }
            if (!line.equals(config.getString("header.separator"))) continue;
            headerSeparatorFound = true;
            header.remove(line);
            break;
        }
        if (headerSeparatorFound) {
            headerValid = true;
            for (String headerLine : header) {
                if (headerLine.contains("=")) continue;
                headerValid = false;
                break;
            }
        }
        return headerValid && statusFound && typeFound;
    }

    private void processHeader(Configuration config, List<String> contents, Map<String, Object> content) {
        for (String line : contents) {
            String[] parts;
            if (line.equals(config.getString("header.separator"))) break;
            if (line.isEmpty() || (parts = line.split("=", 2)).length != 2) continue;
            String utf8BOM = "\ufeff";
            String key = parts[0].contains(utf8BOM) ? parts[0].trim().replace(utf8BOM, "") : parts[0].trim();
            String value = parts[1].trim();
            if (key.equalsIgnoreCase("date")) {
                SimpleDateFormat df = new SimpleDateFormat(config.getString("date.format"));
                Date date = null;
                try {
                    date = df.parse(value);
                    content.put(key, date);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (key.equalsIgnoreCase("tags")) {
                content.put(key, this.getTags(value));
                continue;
            }
            if (this.isJson(value)) {
                content.put(key, JSONValue.parse((String)value));
                continue;
            }
            content.put(key, value);
        }
    }

    private String[] getTags(String tagsPart) {
        String[] tags = tagsPart.split(",");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
        }
        return tags;
    }

    private boolean isJson(String part) {
        return part.startsWith("{") && part.endsWith("}");
    }

    private void processBody(Configuration config, List<String> contents, Map<String, Object> content) {
        StringBuilder body = new StringBuilder();
        boolean inBody = false;
        for (String line : contents) {
            if (inBody) {
                body.append(line).append("\n");
            }
            if (!line.equals(config.getString("header.separator"))) continue;
            inBody = true;
        }
        if (body.length() == 0) {
            for (String line : contents) {
                body.append(line).append("\n");
            }
        }
        content.put("body", body.toString());
    }
}

