/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.render;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.app.DocumentList;
import org.jbake.app.Renderer;
import org.jbake.model.DocumentTypes;
import org.jbake.render.RenderingTool;
import org.jbake.template.RenderingException;

public class DocumentsRenderer
implements RenderingTool {
    @Override
    public int render(Renderer renderer, ContentStore db, File destination, File templatesPath, CompositeConfiguration config) throws RenderingException {
        int renderedCount = 0;
        LinkedList<String> errors = new LinkedList<String>();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            DocumentList documentList = db.getUnrenderedContent(docType);
            if (documentList == null) continue;
            Map nextDocument = null;
            for (int index = 0; index < documentList.size(); ++index) {
                try {
                    Map document = (Map)documentList.get(index);
                    document.put("nextContent", null);
                    document.put("previousContent", null);
                    if (index > 0) {
                        document.put("nextContent", this.getContentForNav(nextDocument));
                    }
                    if (index < documentList.size() - 1) {
                        Map tempNext = (Map)documentList.get(index + 1);
                        document.put("previousContent", this.getContentForNav(tempNext));
                    }
                    nextDocument = document;
                    renderer.render(document);
                    ++renderedCount;
                    continue;
                }
                catch (Exception e) {
                    errors.add(e.getMessage());
                }
            }
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to render documents. Cause(s):");
            for (String error : errors) {
                sb.append("\n").append(error);
            }
            throw new RenderingException(sb.toString());
        }
        return renderedCount;
    }

    private Map<String, Object> getContentForNav(Map<String, Object> document) {
        HashMap<String, Object> navDocument = new HashMap<String, Object>();
        navDocument.put("noExtensionUri", document.get("noExtensionUri"));
        navDocument.put("uri", document.get("uri"));
        navDocument.put("title", document.get("title"));
        return navDocument;
    }
}

