/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.BeansWrapperBuilder;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jbake.app.ContentStore;
import org.jbake.template.AbstractTemplateEngine;
import org.jbake.template.NoModelExtractorException;
import org.jbake.template.RenderingException;
import org.jbake.template.TemplateEngineAdapter;

public class FreemarkerTemplateEngine
extends AbstractTemplateEngine {
    private Configuration templateCfg;

    public FreemarkerTemplateEngine(CompositeConfiguration config, ContentStore db, File destination, File templatesPath) {
        super((org.apache.commons.configuration.Configuration)config, db, destination, templatesPath);
        this.createTemplateConfiguration(config, templatesPath);
    }

    private void createTemplateConfiguration(CompositeConfiguration config, File templatesPath) {
        this.templateCfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        this.templateCfg.setDefaultEncoding(config.getString("render.encoding"));
        try {
            this.templateCfg.setDirectoryForTemplateLoading(templatesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void renderDocument(Map<String, Object> model, String templateName, Writer writer) throws RenderingException {
        try {
            Template template = this.templateCfg.getTemplate(templateName);
            template.process((Object)new LazyLoadingModel(this.templateCfg.getObjectWrapper(), model, this.db), writer);
        }
        catch (IOException e) {
            throw new RenderingException(e);
        }
        catch (TemplateException e) {
            throw new RenderingException(e);
        }
    }

    public static class LazyLoadingModel
    implements TemplateHashModel {
        private final ObjectWrapper wrapper;
        private final SimpleHash eagerModel;
        private final ContentStore db;

        public LazyLoadingModel(ObjectWrapper wrapper, Map<String, Object> eagerModel, ContentStore db) {
            this.eagerModel = new SimpleHash(eagerModel, wrapper);
            this.db = db;
            this.wrapper = wrapper;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            try {
                if (key.equals("db")) {
                    BeansWrapperBuilder bwb = new BeansWrapperBuilder(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
                    BeansWrapper bw = bwb.build();
                    return bw.wrap((Object)this.db);
                }
                return AbstractTemplateEngine.extractors.extractAndTransform(this.db, key, this.eagerModel.toMap(), new TemplateEngineAdapter<TemplateModel>(){

                    @Override
                    public TemplateModel adapt(String key, Object extractedValue) {
                        if (key.equals("alltags")) {
                            return new SimpleCollection((Collection)extractedValue, LazyLoadingModel.this.wrapper);
                        }
                        if (key.equals("published_date")) {
                            return new SimpleDate((Date)extractedValue, 0);
                        }
                        return new SimpleSequence((Collection)extractedValue, LazyLoadingModel.this.wrapper);
                    }
                });
            }
            catch (NoModelExtractorException e) {
                return this.eagerModel.get(key);
            }
        }

        public boolean isEmpty() throws TemplateModelException {
            return false;
        }
    }
}

