/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.util;

import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class HtmlUtil {
    public static void fixImageSourceUrls(Map<String, Object> fileContents, CompositeConfiguration config) {
        String htmlContent = fileContents.get("body").toString();
        String siteHost = config.getString("site.host");
        String uri = fileContents.get("uri").toString();
        if (fileContents.get("noExtensionUri") != null && (uri = fileContents.get("noExtensionUri").toString()).endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.contains("/")) {
            uri = uri.substring(0, uri.lastIndexOf("/") + 1);
        }
        Document document = Jsoup.parseBodyFragment((String)htmlContent);
        Elements allImgs = document.getElementsByTag("img");
        for (Element img : allImgs) {
            String source = img.attr("src");
            if (source.startsWith("./")) {
                source = source.replaceFirst("./", uri);
            }
            if (source.startsWith("http://") || source.startsWith("https://")) continue;
            if (!siteHost.endsWith("/") && !source.startsWith("/")) {
                siteHost = siteHost.concat("/");
            }
            String fullUrl = siteHost + source;
            img.attr("src", fullUrl);
        }
        fileContents.put("body", document.body().html());
    }
}

