/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.util;

import java.net.URI;
import java.net.URISyntaxException;

public class PagingHelper {
    private static final String URI_SEPARATOR = "/";
    private long totalDocuments;
    private int postsPerPage;

    public PagingHelper(long totalDocuments, int postsPerPage) {
        this.totalDocuments = totalDocuments;
        this.postsPerPage = postsPerPage;
    }

    public int getNumberOfPages() {
        return (int)Math.ceil((double)this.totalDocuments * 1.0 / ((double)this.postsPerPage * 1.0));
    }

    public String getNextFileName(int currentPageNumber) throws URISyntaxException {
        if (currentPageNumber < this.getNumberOfPages()) {
            return new URI(currentPageNumber + 1 + URI_SEPARATOR).toString();
        }
        return null;
    }

    public String getPreviousFileName(int currentPageNumber) throws URISyntaxException {
        if (this.isFirstPage(currentPageNumber)) {
            return null;
        }
        if (currentPageNumber == 2) {
            return "";
        }
        return new URI(currentPageNumber - 1 + URI_SEPARATOR).toString();
    }

    private boolean isFirstPage(int page) {
        return page == 1;
    }

    public String getCurrentFileName(int page, String fileName) throws URISyntaxException {
        if (this.isFirstPage(page)) {
            return fileName;
        }
        return new URI(page + URI_SEPARATOR + fileName).toString();
    }
}

