/*
 * Decompiled with CFR 0.152.
 */
package org.jbake.app;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePoolFactory;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbake.app.DBUtil;
import org.jbake.app.DocumentList;
import org.jbake.app.FileUtil;
import org.jbake.app.JBakeException;
import org.jbake.model.DocumentAttributes;
import org.jbake.model.DocumentTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStore {
    private static final String STATEMENT_GET_PUBLISHED_POST_BY_TYPE_AND_TAG = "select * from %s where status='published' and ? in tags order by date desc";
    private static final String STATEMENT_GET_DOCUMENT_STATUS_BY_DOCTYPE_AND_URI = "select sha1,rendered from %s where sourceuri=?";
    private static final String STATEMENT_GET_PUBLISHED_COUNT = "select count(*) as count from %s where status='published'";
    private static final String STATEMENT_MARK_CONTENT_AS_RENDERD = "update %s set rendered=true where rendered=false and cached=true";
    private static final String STATEMENT_DELETE_DOCTYPE_BY_SOURCEURI = "delete from %s where sourceuri=?";
    private static final String STATEMENT_GET_UNDRENDERED_CONTENT = "select * from %s where rendered=false order by date desc";
    private static final String STATEMENT_GET_SIGNATURE_FOR_TEMPLATES = "select sha1 from Signatures where key='templates'";
    private static final String STATEMENT_GET_TAGS_FROM_PUBLISHED_POSTS = "select tags from post where status='published'";
    private static final String STATEMENT_GET_ALL_CONTENT_BY_DOCTYPE = "select * from %s order by date desc";
    private static final String STATEMENT_GET_PUBLISHED_CONTENT_BY_DOCTYPE = "select * from %s where status='published' order by date desc";
    private static final String STATEMENT_GET_PUBLISHED_POSTS_BY_TAG = "select * from post where status='published' and ? in tags order by date desc";
    private static final String STATEMENT_GET_TAGS_BY_DOCTYPE = "select tags from %s where status='published'";
    private static final String STATEMENT_INSERT_TEMPLATES_SIGNATURE = "insert into Signatures(key,sha1) values('templates',?)";
    private static final String STATEMENT_DELETE_ALL = "delete from %s";
    private static final String STATEMENT_UPDATE_TEMPLATE_SIGNATURE = "update Signatures set sha1=? where key='templates'";
    private final Logger logger = LoggerFactory.getLogger(ContentStore.class);
    private final String type;
    private final String name;
    private ODatabaseDocumentTx db;
    private long start = -1L;
    private long limit = -1L;

    public ContentStore(String type, String name) {
        this.type = type;
        this.name = name;
    }

    public ODatabaseDocumentTx getDb() {
        return this.db;
    }

    public void setDb(ODatabaseDocumentTx db) {
        this.db = db;
    }

    public void startup() {
        this.startupIfEnginesAreMissing();
        OPartitionedDatabasePool pool = new OPartitionedDatabasePoolFactory().get(this.type + ":" + this.name, "admin", "admin");
        pool.setAutoCreate(true);
        this.db = pool.acquire();
        ODatabaseRecordThreadLocal.instance().set((ODatabaseDocumentInternal)this.db);
        this.updateSchema();
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void resetPagination() {
        this.start = -1L;
        this.limit = -1L;
    }

    public final void updateSchema() {
        if (this.db.isClosed()) {
            this.db.create();
        }
        OSchemaProxy schema = this.db.getMetadata().getSchema();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            if (schema.existsClass(docType)) continue;
            this.createDocType((OSchema)schema, docType);
        }
        if (!schema.existsClass("Signatures")) {
            this.createSignatureType((OSchema)schema);
        }
    }

    public void close() {
        if (this.db != null) {
            this.activateOnCurrentThread();
            this.db.close();
        }
        DBUtil.closeDataStore();
    }

    public void shutdown() {
        Orient.instance().shutdown();
    }

    private void startupIfEnginesAreMissing() {
        OLogManager.instance().setWarnEnabled(false);
        if (Orient.instance().getEngines().isEmpty()) {
            Orient.instance().startup();
        }
        OLogManager.instance().setWarnEnabled(true);
    }

    public void drop() {
        this.activateOnCurrentThread();
        this.db.drop();
    }

    private void activateOnCurrentThread() {
        this.db.activateOnCurrentThread();
    }

    public ODocument mergeDocument(Map<String, ? extends Object> incomingDocMap) {
        String sourceUri = (String)incomingDocMap.get(DocumentAttributes.SOURCE_URI.toString());
        if (null == sourceUri) {
            throw new IllegalArgumentException("Document sourceUri is null.");
        }
        String docType = (String)incomingDocMap.get("type");
        if (null == docType) {
            throw new IllegalArgumentException("Document docType is null.");
        }
        String sql = "SELECT * FROM " + docType + " WHERE sourceuri=?";
        this.activateOnCurrentThread();
        List results = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(sql)).execute(new Object[]{sourceUri});
        if (results.size() == 0) {
            throw new JBakeException("No document with sourceUri '" + sourceUri + "'.");
        }
        ODocument incomingDoc = new ODocument(docType);
        incomingDoc.fromMap(incomingDocMap);
        ODocument merged = ((ODocument)results.get(0)).merge(incomingDoc, true, false);
        return merged;
    }

    public long getDocumentCount(String docType) {
        this.activateOnCurrentThread();
        return this.db.countClass(docType);
    }

    public long getPublishedCount(String docType) {
        String statement = String.format(STATEMENT_GET_PUBLISHED_COUNT, docType);
        return (Long)((Map)this.query(statement).get(0)).get("count");
    }

    public DocumentList getDocumentByUri(String docType, String uri) {
        return this.query("select * from " + docType + " where sourceuri=?", uri);
    }

    public DocumentList getDocumentStatus(String docType, String uri) {
        String statement = String.format(STATEMENT_GET_DOCUMENT_STATUS_BY_DOCTYPE_AND_URI, docType);
        return this.query(statement, uri);
    }

    public DocumentList getPublishedPosts() {
        return this.getPublishedContent("post");
    }

    public DocumentList getPublishedPosts(boolean applyPaging) {
        return this.getPublishedContent("post", applyPaging);
    }

    public DocumentList getPublishedPostsByTag(String tag) {
        return this.query(STATEMENT_GET_PUBLISHED_POSTS_BY_TAG, tag);
    }

    public DocumentList getPublishedDocumentsByTag(String tag) {
        DocumentList documents = new DocumentList();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            String statement = String.format(STATEMENT_GET_PUBLISHED_POST_BY_TYPE_AND_TAG, docType);
            DocumentList documentsByTag = this.query(statement, tag);
            documents.addAll(documentsByTag);
        }
        return documents;
    }

    public DocumentList getPublishedPages() {
        return this.getPublishedContent("page");
    }

    public DocumentList getPublishedContent(String docType) {
        return this.getPublishedContent(docType, false);
    }

    private DocumentList getPublishedContent(String docType, boolean applyPaging) {
        String query = String.format(STATEMENT_GET_PUBLISHED_CONTENT_BY_DOCTYPE, docType);
        if (applyPaging && this.hasStartAndLimitBoundary()) {
            query = query + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(query);
    }

    public DocumentList getAllContent(String docType) {
        return this.getAllContent(docType, false);
    }

    public DocumentList getAllContent(String docType, boolean applyPaging) {
        String query = String.format(STATEMENT_GET_ALL_CONTENT_BY_DOCTYPE, docType);
        if (applyPaging && this.hasStartAndLimitBoundary()) {
            query = query + " SKIP " + this.start + " LIMIT " + this.limit;
        }
        return this.query(query);
    }

    private boolean hasStartAndLimitBoundary() {
        return this.start >= 0L && this.limit > -1L;
    }

    private DocumentList getAllTagsFromPublishedPosts() {
        return this.query(STATEMENT_GET_TAGS_FROM_PUBLISHED_POSTS);
    }

    private DocumentList getSignaturesForTemplates() {
        return this.query(STATEMENT_GET_SIGNATURE_FOR_TEMPLATES);
    }

    public DocumentList getUnrenderedContent(String docType) {
        String statement = String.format(STATEMENT_GET_UNDRENDERED_CONTENT, docType);
        return this.query(statement);
    }

    public void deleteContent(String docType, String uri) {
        String statement = String.format(STATEMENT_DELETE_DOCTYPE_BY_SOURCEURI, docType);
        this.executeCommand(statement, uri);
    }

    public void markContentAsRendered(String docType) {
        String statement = String.format(STATEMENT_MARK_CONTENT_AS_RENDERD, docType);
        this.executeCommand(statement, new Object[0]);
    }

    private void updateSignatures(String currentTemplatesSignature) {
        this.executeCommand(STATEMENT_UPDATE_TEMPLATE_SIGNATURE, currentTemplatesSignature);
    }

    public void deleteAllByDocType(String docType) {
        String statement = String.format(STATEMENT_DELETE_ALL, docType);
        this.executeCommand(statement, new Object[0]);
    }

    private void insertTemplatesSignature(String currentTemplatesSignature) {
        this.executeCommand(STATEMENT_INSERT_TEMPLATES_SIGNATURE, currentTemplatesSignature);
    }

    private DocumentList query(String sql) {
        this.activateOnCurrentThread();
        List results = this.db.query((OQuery)new OSQLSynchQuery(sql), new Object[0]);
        return DocumentList.wrap(results.iterator());
    }

    private DocumentList query(String sql, Object ... args) {
        this.activateOnCurrentThread();
        List results = (List)this.db.command((OCommandRequest)new OSQLSynchQuery(sql)).execute(args);
        return DocumentList.wrap(results.iterator());
    }

    private void executeCommand(String query, Object ... args) {
        this.activateOnCurrentThread();
        this.db.command((OCommandRequest)new OCommandSQL(query)).execute(args);
    }

    public Set<String> getTags() {
        DocumentList docs = this.getAllTagsFromPublishedPosts();
        HashSet<String> result = new HashSet<String>();
        for (Map document : docs) {
            String[] tags = DBUtil.toStringArray(document.get("tags"));
            Collections.addAll(result, tags);
        }
        return result;
    }

    public Set<String> getAllTags() {
        HashSet<String> result = new HashSet<String>();
        for (String docType : DocumentTypes.getDocumentTypes()) {
            String statement = String.format(STATEMENT_GET_TAGS_BY_DOCTYPE, docType);
            DocumentList docs = this.query(statement);
            for (Map document : docs) {
                String[] tags = DBUtil.toStringArray(document.get("tags"));
                Collections.addAll(result, tags);
            }
        }
        return result;
    }

    private void createDocType(OSchema schema, String docType) {
        this.logger.debug("Create document class '{}'", (Object)docType);
        OClass page = schema.createClass(docType);
        String attribName = DocumentAttributes.SOURCE_URI.toString();
        page.createProperty(attribName, OType.STRING).setNotNull(true);
        page.createIndex(docType + "sourceUriIndex", OClass.INDEX_TYPE.UNIQUE, new String[]{attribName});
        attribName = DocumentAttributes.SHA1.toString();
        page.createProperty(attribName, OType.STRING).setNotNull(true);
        page.createIndex(docType + "sha1Index", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{attribName});
        attribName = DocumentAttributes.CACHED.toString();
        page.createProperty(attribName, OType.BOOLEAN).setNotNull(true);
        page.createIndex(docType + "cachedIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{attribName});
        attribName = DocumentAttributes.RENDERED.toString();
        page.createProperty(attribName, OType.BOOLEAN).setNotNull(true);
        page.createIndex(docType + "renderedIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{attribName});
        attribName = DocumentAttributes.STATUS.toString();
        page.createProperty(attribName, OType.STRING).setNotNull(true);
        page.createIndex(docType + "statusIndex", OClass.INDEX_TYPE.NOTUNIQUE, new String[]{attribName});
    }

    private void createSignatureType(OSchema schema) {
        OClass signatures = schema.createClass("Signatures");
        signatures.createProperty(String.valueOf((Object)DocumentAttributes.SHA1), OType.STRING).setNotNull(true);
        signatures.createIndex("sha1Idx", OClass.INDEX_TYPE.UNIQUE, new String[]{DocumentAttributes.SHA1.toString()});
    }

    public void updateAndClearCacheIfNeeded(boolean needed, File templateFolder) {
        boolean clearCache = needed;
        if (!needed) {
            clearCache = this.updateTemplateSignatureIfChanged(templateFolder);
        }
        if (clearCache) {
            this.deleteAllDocumentTypes();
            this.updateSchema();
        }
    }

    private boolean updateTemplateSignatureIfChanged(File templateFolder) {
        String currentTemplatesSignature;
        boolean templateSignatureChanged = false;
        DocumentList docs = this.getSignaturesForTemplates();
        try {
            currentTemplatesSignature = FileUtil.sha1(templateFolder);
        }
        catch (Exception e) {
            currentTemplatesSignature = "";
        }
        if (!docs.isEmpty()) {
            String sha1 = (String)((Map)docs.get(0)).get(String.valueOf((Object)DocumentAttributes.SHA1));
            if (!sha1.equals(currentTemplatesSignature)) {
                this.updateSignatures(currentTemplatesSignature);
                templateSignatureChanged = true;
            }
        } else {
            this.insertTemplatesSignature(currentTemplatesSignature);
            templateSignatureChanged = true;
        }
        return templateSignatureChanged;
    }

    private void deleteAllDocumentTypes() {
        for (String docType : DocumentTypes.getDocumentTypes()) {
            try {
                this.deleteAllByDocType(docType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isActive() {
        return this.db.isActiveOnCurrentThread();
    }
}

